package com.bcxin.message.service;

import cn.wildfirechat.pojos.InputCreateChannel;
import cn.wildfirechat.pojos.InputCreateRobot;
import cn.wildfirechat.pojos.OutputCreateChannel;
import cn.wildfirechat.sdk.AdminConfig;
import cn.wildfirechat.sdk.MessageAdmin;
import cn.wildfirechat.sdk.UserAdmin;
import cn.wildfirechat.sdk.utilities.AdminHttpUtils;
import com.bcxin.message.dtos.request.CreateChannelRequest;
import com.bcxin.message.dtos.request.CreateRobotRequest;
import com.bcxin.message.dtos.request.SendRobotMessageRequest;
import com.bcxin.message.service.messagecenter.MsgAdminUserSenderService;
import com.bcxin.message.strategy.message.SendMessageStrategy;
import com.bcxin.message.strategy.message.SendMessageStrategyFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

/**
 * description：野火服务层
 * author：linchunpeng
 * date：2023/10/16
 */
@Service
@Slf4j
public class YehuoService {

    @Autowired
    private MsgAdminUserSenderService msgAdminUserSenderService;

    /**
     * description：创建机器人
     * author：linchunpeng
     * date：2023/11/21
     */
    public void createRobot(CreateRobotRequest request) {
        try {
            InputCreateRobot bcx = new InputCreateRobot();
            bcx.setUserId(request.getUserId());
            bcx.setName(request.getUserId());
            bcx.setSecret(request.getUserId().concat("_secret"));
            bcx.setDisplayName(request.getDisplayName());
            bcx.setPortrait(request.getPortrait());
            UserAdmin.createRobot(bcx);
        } catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage(), e);
        }
    }


    /**
     * description：创建频道
     * author：linchunpeng
     * date：2023/11/21
     */
    public void createChannel(CreateChannelRequest request) {
        try {
            InputCreateChannel createChannel = new InputCreateChannel();
            createChannel.setOwner(request.getOwner());
            createChannel.setName(request.getName());
            createChannel.setTargetId(request.getTargetId());
            createChannel.setSecret(request.getTargetId().concat("_secret"));
            createChannel.setPortrait(request.getPortrait());
            createChannel.setDesc(request.getDesc());

            //0，owner会接收到消息，如果配置callback同时会转发消息；1，owner不会接收消息，如果配置callback会转发消息到callback
            createChannel.setAuto(1);
            //频道属性
            //0x01是否允许查看用户所有信息
            //0x02是否允许查看非订阅用户信息
            //0x04是否允许主动添加用户订阅关系
            //0x08是否允许给非订阅用户发送消息
            //0x10是否私有，私有频道不能被用户搜索和添加
            //0x80全局频道
            createChannel.setState(0x08);

            String path = "/admin/channel/create";
            AdminHttpUtils.httpJsonPost(path, createChannel, OutputCreateChannel.class);

        } catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage(), e);
        }
    }


    /**
     * description：多线程 发送文本消息
     * author：linchunpeng
     * date：2023/11/21
     */
    @Async
    public void sendMessage(SendRobotMessageRequest request) {
        SendMessageStrategy sendMessageStrategy = SendMessageStrategyFactory.getInstance(request.getSenderType(), request.getTargetType(), request.getMessageType());
        sendMessageStrategy.sendMessage(request);
    }


    public static void main(String[] args) {
        AdminConfig.initAdmin(" http://testim.baibaodun.com.cn:18080", "123456");
        try {
            MessageAdmin.deleteMessage(502883466382147713L);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
