package com.bcxin.message.scheduled.task;

import com.bcxin.message.service.messagecenter.MsgExpiredTimeService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * description：删除过期消息任务
 * author：linchunpeng
 * date：2025/8/12
 */
@Slf4j
@Component
public class DeleteExpiredMsgTask {

    @Autowired
    private MsgExpiredTimeService msgExpiredTimeService;

    @Scheduled(cron = "${message.delete-expired-msg-task.cron}")
    public void deleteExpiredMsgTask() {
        log.info("===================================删除过期消息任务===================================");
        msgExpiredTimeService.deleteExpiredMsg();
        log.info("===================================删除过期消息任务结束===================================");
    }

}
