package com.bcxin.message.entity.messagecenter;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

/**
 * description：消息中心-消息组织有效期表
 * author：linchunpeng
 * date：2025/8/11
 */
@Data
@TableName("msg_org_effective_time")
public class MsgOrgEffectiveTimeEntity {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id")
    private Long id;

    //组织id
    private String organizationId;

    //有效时间，天数
    private Integer effectiveTime;

    //创建时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date createTime;

    //最后修改时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date updateTime;

}
