package com.bcxin.message.dtos.yehuo;

import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.util.Date;

@Data
public class TMessagesResponse {

    //主键id
    @TableId(value = "id")
    private Long id;

    //消息id
    private Long mid;

    //发送者用户id
    private String from;

    //消息类型，0用户消息，1群组消息
    private Integer type;

    //接收用户id/群组id
    private String target;

    //发送时间
    private Date dt;

    //群组所属用户id
    private String ownerUserId;

    //表空间序号
    private Integer number;

    /**
     * 获取这条消息的所有用户id
     */
    public String getAllUserId() {
        StringBuffer sb = new StringBuffer(128);
        sb.append(from);
        if (type == 0) {
            sb.append(";").append(target);
        } else if (type == 1 && StringUtils.isNotBlank(ownerUserId)) {
            sb.append(";").append(ownerUserId);
        }
        return sb.toString();
    }

}
