package com.bcxin.message.dtos.request;

import lombok.Data;

import javax.validation.constraints.NotBlank;

@Data
public class CreateChannelRequest {

    /**
     * 拥有者
     */
    @NotBlank(message = "拥有者不能为空")
    private String owner;

    /**
     * 频道用户id
     */
    @NotBlank(message = "频道用户id不能为空")
    private String targetId;

    /**
     * 频道名称
     */
    @NotBlank(message = "频道名称名称不能为空")
    private String name;

    /**
     * 频道头像地址
     */
    @NotBlank(message = "频道头像地址不能为空")
    private String portrait;

    /**
     * 频道描述
     */
    @NotBlank(message = "频道描述不能为空")
    private String desc;

}

