package com.bcxin.message.controller;


import com.bcxin.message.dtos.request.SendRobotMessageRequest;
import com.bcxin.message.dtos.response.MsgSendLogResponse;
import com.bcxin.message.dtos.response.SendMessageResponse;
import com.bcxin.message.dtos.response.result.RespResult;
import com.bcxin.message.entity.messagecenter.MsgSendLogEntity;
import com.bcxin.message.service.messagecenter.MsgSendLogService;
import com.bcxin.message.service.YehuoService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * description：发送消息接口
 * author：linchunpeng
 * date：2023/11/21
 */
@Slf4j
@RestController
@RequestMapping("/api/v1/send/message")
public class SendMessageController {

    @Autowired
    private YehuoService yehuoService;
    @Autowired
    private MsgSendLogService msgSendLogService;

    /**
     * description：发送文本消息
     * author：linchunpeng
     * date：2023/11/21
     */
    @PostMapping("/do")
    public RespResult<SendMessageResponse> doSend(@RequestBody @Valid SendRobotMessageRequest request) {
        yehuoService.sendMessage(request);
        return RespResult.successful(new SendMessageResponse(request.getRequestId()), "发送成功");
    }

    /**
     * description：根据requestId，查询发送记录
     * author：linchunpeng
     * date：2023/11/27
     */
    @GetMapping("/get/{requestId}")
    public RespResult<MsgSendLogResponse> getMessage(@PathVariable String requestId) {
        MsgSendLogEntity msgSendLogEntity = msgSendLogService.findByRequestId(requestId);
        MsgSendLogResponse msgSendLogResponse = new MsgSendLogResponse();
        BeanUtils.copyProperties(msgSendLogEntity, msgSendLogResponse);
        return RespResult.successful(msgSendLogResponse, "查询成功");
    }
}
