package com.bcxin.message.common.utils;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * description: 时间工具类
 * author: linchunpeng
 * date:  2023-04-18 11:21
 */
public class DateUtil extends cn.hutool.core.date.DateUtil {

    private final static SimpleDateFormat yyyyMMdd = new SimpleDateFormat("yyyy-MM-dd");
    private final static SimpleDateFormat yyyyMMddHHmmss = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    /**
     * description: 根据时间获取当天0点的时间
     * author: linchunpeng
     * date:  2023-04-18 13:55
     */
    public static Date getDateZeroTime(Date date) {
       Calendar calendar = Calendar.getInstance();
       calendar.setTime(date);
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        calendar.set(Calendar.MILLISECOND, 0);
        return calendar.getTime();
    }

    /**
     * description: 根据时间获取当天0点的时间
     * author: linchunpeng
     * date:  2023-04-18 13:55
     */
    public static Date getBeforeNumDayZeroTime(Date date, int before) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(Calendar.DAY_OF_YEAR, calendar.get(Calendar.DAY_OF_YEAR) - before);
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        calendar.set(Calendar.MILLISECOND, 0);
        return calendar.getTime();
    }

    /**
     * description: 根据时间获取当时0分的时间
     * author: linchunpeng
     * date:  2023-04-18 13:55
     */
    public static Date getMinuteZeroTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        calendar.set(Calendar.MILLISECOND, 0);
        return calendar.getTime();
    }

    /**
     * description: 根据时间获取后几分钟的时间
     * author: linchunpeng
     * date:  2023-04-18 13:55
     */
    public static Date getAfterNumMinuteTime(Date date, int after) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(Calendar.MINUTE, calendar.get(Calendar.MINUTE) + after);
        return calendar.getTime();
    }

    /**
     * description: 获取星期几英文
     * author: linchunpeng
     * date:  2023-04-18 11:21
     */
    public static String getWeekEngStrOfDate(Date date) {
        String[] weekDays = { "sunday", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday" };
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int w = cal.get(Calendar.DAY_OF_WEEK) - 1;
        if (w < 0)
            w = 0;
        return weekDays[w];
    }

    /**
     * description: 获取星期几中文
     * author: linchunpeng
     * date:  2023-04-18 11:21
     */
    public static String getWeekStrOfDate(Date date) {
        String[] weekDays = { "星期日", "星期一", "星期二", "星期三", "星期四", "星期五", "星期六" };
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int w = cal.get(Calendar.DAY_OF_WEEK) - 1;
        if (w < 0)
            w = 0;
        return weekDays[w];
    }

    /**
     * description: 获取星期几数字
     * author: linchunpeng
     * date:  2023-04-18 11:21
     */
    public static int getWeekIntOfDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int w = cal.get(Calendar.DAY_OF_WEEK) - 1;
        if (w < 0)
            w = 7;
        return w;
    }
}
