package com.bcxin.message.strategy.message.impl;

import cn.wildfirechat.common.ErrorCode;
import cn.wildfirechat.pojos.MessagePayload;
import cn.wildfirechat.pojos.SendMessageResult;
import cn.wildfirechat.sdk.RobotService;
import cn.wildfirechat.sdk.model.IMResult;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.message.dtos.request.SendRobotMessageRequest;
import com.bcxin.message.service.messagecenter.MsgSendLogService;
import com.bcxin.message.strategy.message.SendMessageStrategy;
import com.bcxin.message.strategy.message.SendMessageStrategyFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/**
 * description：机器人发送文本消息
 * author：linchunpeng
 * date：2023/11/7
 */
@Slf4j
@Service
public class RobotSendTextMsg implements SendMessageStrategy {

    @Value("${ye-huo.im-server.url}")
    private String appServerUrl;
    @Autowired
    private MsgSendLogService msgSendLogService;


    /**
     * description：发送消息
     * author：linchunpeng
     * date：2023/11/21
     */
    @Override
    public void sendMessage(SendRobotMessageRequest request) {
        String sender = request.getSender();
        RobotService robotService = new RobotService(appServerUrl, sender, sender.concat("_secret"));
        for (String targetId : request.getTargetIds()) {
            int sendSuccess = 0;
            String sendResultStr = "";
            try {
                //消息载体
                MessagePayload payload = new MessagePayload();
                //内容类型，1文本消息内容，2语音消息内容，3图片消息内容，4位置消息内容，5文件消息内容，6视频消息内容，7动态表情消息内容，8图文消息混排内容
                payload.setType(1);
                //存储标志
                payload.setPersistFlag(3);
                //消息可搜索内容
                payload.setSearchableContent(request.getMessageContentObject().getContent());
                //消息内容
                payload.setContent(request.getMessageContentObject().getContent());
                //消息推送内容
                payload.setPushContent(request.getMessageContentObject().getContent());

                IMResult<SendMessageResult> sendResult = robotService.sendMessage(sender,
                        SendMessageStrategyFactory.getConversation(request.getTargetType(), targetId), payload);
                sendResultStr = JSONObject.toJSONString(sendResult);
                log.info("请求id：{}，机器人发送文本消息，发送结果：{}", request.getRequestId(), sendResultStr);
                if (sendResult != null && sendResult.getErrorCode() == ErrorCode.ERROR_CODE_SUCCESS) {
                    log.info("请求id：{}，机器人发送文本消息，发送成功", request.getRequestId());
                    sendSuccess = 1;
                } else {
                    log.info("请求id：{}，机器人发送文本消息，发送失败", request.getRequestId());
                }
            } catch (Exception e) {
                e.printStackTrace();
                log.error("请求id：{}，机器人发送文本消息，发送失败", e.getMessage(), e);
                sendResultStr = e.getMessage();
            }
            msgSendLogService.record(request, "RobotSendUserTextMsg", sendSuccess, sendResultStr);
        }
    }
}
