package com.bcxin.message.service.yehuo;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.message.dao.mapper.yehuo.TGroupMapper;
import com.bcxin.message.entity.yehuo.TGroupEntity;
import com.bcxin.message.service.RedisCache;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * description：野火-群组表
 * author：linchunpeng
 * date：2024/12/31
 */
@Slf4j
@Service
public class TGroupService extends ServiceImpl<TGroupMapper, TGroupEntity> {

    @Autowired
    private RedisCache redisCache;

    /**
     * description：查询群组的创建者id
     * author：linchunpeng
     * date：2025/8/11
     */
    public String getOwnerByGid(String gid) {
        String key = "message-center:group:owner:" + gid;
        String value = redisCache.getCacheObject(key);
        if (value != null) {
            return value;
        }
        LambdaQueryChainWrapper<TGroupEntity> lqw = this.lambdaQuery();
        lqw.eq(TGroupEntity::getGid, gid);
        TGroupEntity group = lqw.one();
        if (group != null) {
            value = group.getOwner();
        }
        redisCache.setCacheObject(key, value, 1, TimeUnit.HOURS);
        return value;
    }

}