package com.bcxin.message.service.messagecenter;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.message.common.emus.MsgSendRequestStatus;
import com.bcxin.message.common.emus.MsgSendSource;
import com.bcxin.message.dao.mapper.messagecenter.MsgSendRequestMapper;
import com.bcxin.message.dtos.kafka.message.MsgSendRequestKafkaMessage;
import com.bcxin.message.dtos.request.SendRobotMessageRequest;
import com.bcxin.message.entity.messagecenter.MsgAdminUserSenderEntity;
import com.bcxin.message.entity.messagecenter.MsgSendRequestEntity;
import com.bcxin.message.service.YehuoService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Arrays;
import java.util.Date;
import java.util.stream.Collectors;

/**
 * description：消息发送请求表 service
 * author：linchunpeng
 * date：2025/7/9
 */
@Slf4j
@Service
public class MsgSendRequestService extends ServiceImpl<MsgSendRequestMapper, MsgSendRequestEntity> {

    @Autowired
    private YehuoService yehuoService;
    @Autowired
    private MsgAdminUserSenderService msgAdminUserSenderService;

    /**
     * description：更新发送状态
     * author：linchunpeng
     * date：2025/7/9
     */
    @Transactional
    public void updateSendStatus(String requestId, MsgSendRequestStatus status) {
        this.lambdaUpdate()
                .eq(MsgSendRequestEntity::getRequestId, requestId)
                .set(MsgSendRequestEntity::getStatus, status.getCode())
                .set(MsgSendRequestEntity::getUpdateTime, new Date())
                .update();
    }

    /**
     * description：发送消息
     * author：linchunpeng
     * date：2025/7/9
     */
    @Transactional
    public void sendMessage(MsgSendRequestKafkaMessage kafkaMessage) {
        MsgAdminUserSenderEntity msgAdminUserSenderEntity = msgAdminUserSenderService.findByAppidAndSender(kafkaMessage.getAppid(), kafkaMessage.getSender());
        if (msgAdminUserSenderEntity == null) {
            log.error("appid：{}，未授权sender：{}", kafkaMessage.getAppid(), kafkaMessage.getSender());
            this.lambdaUpdate()
                    .eq(MsgSendRequestEntity::getId, kafkaMessage.getId())
                    .set(MsgSendRequestEntity::getStatus, MsgSendRequestStatus.FAIL.getCode())
                    .set(MsgSendRequestEntity::getRemark, String.format("appid：%s，未授权sender：%s", kafkaMessage.getAppid(), kafkaMessage.getSender()))
                    .set(MsgSendRequestEntity::getUpdateTime, new Date())
                    .update();
        } else {
            log.info("消息中心用户发送者存在，appid：{}，sender{}", msgAdminUserSenderEntity.getAppid(), msgAdminUserSenderEntity.getSender());
            SendRobotMessageRequest sendRobotMessageRequest = new SendRobotMessageRequest();
            sendRobotMessageRequest.setSource(MsgSendSource.SEND_REQUEST_TABLE.getCode());
            sendRobotMessageRequest.setRequestId(kafkaMessage.getRequestId());
            sendRobotMessageRequest.setAppid(msgAdminUserSenderEntity.getAppid());
            sendRobotMessageRequest.setSenderType(msgAdminUserSenderEntity.getSenderType());
            sendRobotMessageRequest.setSender(msgAdminUserSenderEntity.getSender());
            sendRobotMessageRequest.setTargetType(kafkaMessage.getTargetType());
            sendRobotMessageRequest.setTargetIds(Arrays.stream(kafkaMessage.getTargetIds().split(",")).map(userId -> userId = userId.trim()).collect(Collectors.toList()));
            sendRobotMessageRequest.setMessageType(kafkaMessage.getMessageType());
            sendRobotMessageRequest.setMessageContent(kafkaMessage.getMessageContent());
            yehuoService.sendMessage(sendRobotMessageRequest);
        }
    }
}
