package com.bcxin.message.entity.messagecenter;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

/**
 * description：消息中心-消息同步时间任务表
 * author：linchunpeng
 * date：2025/8/11
 */
@Data
@TableName("msg_sync_time_task")
public class MsgSyncTimeTaskEntity {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id")
    private Long id;

    //同步开始时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date startTime;

    //同步结束时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date endTime;

    //同步任务状态，1-开始同步，2-同步完成，-1-同步失败
    private Integer taskStatus;

    //同步结果
    private String syncResult;

    //同步消息总数
    private Integer syncTotalCount;

    //创建时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date createTime;

    //最后修改时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date updateTime;

}
