package com.bcxin.message.entity.messagecenter;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

/**
 * description：消息中心异常表
 * author：linchunpeng
 * date：2023/11/17
 */
@Data
@TableName("msg_exception")
public class MsgExceptionEntity {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id")
    private Long id;

    //请求id
    private String requestId;

    //appid
    private String appid;

    //请求url
    private String requestUrl;

    //请求参数
    private String requestParam;

    //异常信息
    private String exceptionInfo;

    //创建时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date createTime;

    //最后修改时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date updateTime;

}
