package com.bcxin.message.dtos.yehuo;

import lombok.Data;

import java.util.List;
import java.util.Map;

@Data
public class MessageContent {

    /**
     * 消息摘要
     */
    private String digest;
    /**
     * 消息文本内容
     */
    private String content;
    /**
     * 链接url
     */
    private String linkUrl;
    /**
     * 图片url
     */
    private String imgUrl;
    /**
     * 应用名称
     */
    private String appName;
    /**
     * 拓展信息
     */
    private Map<String, Object> extraMap;

    /**
     * 富通知数据
     */
    private List<NoticeData> noticeDataList;

    @Data
    public static class NoticeData {
        private String key;
        private String value;
    }
}

