package com.bcxin.message.dtos.response.result;

import com.bcxin.message.common.emus.StatusCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.Getter;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * 游标类结果
 */
@Getter
@JsonPropertyOrder({"code", "msg", "timestamp", "nextId", "data"})
public class RespCursorResult<V> extends AbstractRespResult {

    /**
     * 下一个游标起点
     */
    private String nextId;

    /**
     * 响应内容，可能为空，如果为空，那么该值会设置为空的MAP
     */
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Object data;

    protected RespCursorResult(V result) {
        super();
        if (result == null) {
            //查看V的类型，决定返回类型
            Type superClass = getClass().getGenericSuperclass();
            if (superClass == null) {
                this.data = new HashMap();
            } else {
                if (superClass instanceof ParameterizedType) {
                    Type[] actualTypeArguments = ((ParameterizedType) superClass).getActualTypeArguments();
                    if (actualTypeArguments != null && actualTypeArguments.length > 0) {
                        Class<?> clazz = (Class<?>) actualTypeArguments[0];
                        if (List.class.isAssignableFrom(clazz)) {
                            this.data = new ArrayList();
                        } else {
                            this.data = new HashMap();
                        }
                    }
                }
            }
        } else {
            this.data = result;
        }
    }

    protected RespCursorResult(String nextId, V result) {
        this(result);
        this.nextId = nextId;
    }


    protected RespCursorResult(StatusCode statusCode, String message) {
        super(statusCode, message);
        this.nextId = null;
    }

    protected RespCursorResult(int code, String message) {
        super(code, message);
        this.nextId = null;
    }

    /**
     * 错误响应
     */
    public static final <T> RespCursorResult<T> failure(StatusCode statusCode) {
        return new RespCursorResult<>(statusCode, statusCode.getDefaultMessage());
    }

    /**
     * 错误响应
     */
    public static final <T> RespCursorResult<T> failure(int statusCode, String message) {
        return new RespCursorResult<>(statusCode, message);
    }

    /**
     * 默认成功返回响应
     */
    public static final <T> RespCursorResult<T> successful() {
        return new RespCursorResult<>(StatusCode.succeed, StatusCode.succeed.getDefaultMessage());
    }

    /**
     * 自定义返回值的成功返回响应
     */
    public static final <T> RespCursorResult<T> successful(String message) {
        return new RespCursorResult<>(StatusCode.succeed, message);
    }

    /**
     * 自定义返回值的成功返回响应
     */
    public static final <T> RespCursorResult<T> successful(String nextId, T result) {
        return new RespCursorResult<>(nextId, result);
    }
}
