package com.bcxin.message.dtos.request;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Data
public class BindSenderRequest {

    /**
     * appid
     */
    @NotBlank(message = "appid不能为空")
    private String appid;

    /**
     * sender
     */
    @NotBlank(message = "sender不能为空")
    private String sender;

    /**
     * 发送者类型，robot机器人，channel频道
     */
    @NotBlank(message = "发送者类型不能为空")
    private String senderType;

    /**
     * 操作类型，1绑定，2解绑
     */
    @NotNull(message = "操作类型不能为空")
    private Integer operateType;

}

