package com.bcxin.message.configs;

import cn.wildfirechat.sdk.AdminConfig;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;

/**
 * description：初始化配置
 * author：linchunpeng
 * date：2023/11/3
 */
@Component
public class InitConfig {

	@Value("${ye-huo.im-server.admin-url}")
	private String appServerAdminUrl;

	@Value("${ye-huo.im-server.secret}")
	private String imServerSecret;

	@PostConstruct
	private void initConfig(){
		//野火初始化
		AdminConfig.initAdmin(appServerAdminUrl, imServerSecret);
	}
	
}