package com.bcxin.message.common.emus;

/**
 * 同步任务状态，0-任务初始化，1-开始同步，2-同步完成，-1-同步失败
 */
public enum MsgSyncTimeTaskStatusEnum {

    //任务初始化
    INIT(0, "任务初始化"),
    //开始同步
    BEGIN_SYNC(1, "开始同步"),
    //同步完成
    SYNC_COMPLETE(2, "同步完成"),
    //同步失败
    SYNC_FAIL(-1, "同步失败");
    /**
     * 状态代码
     */
    private int code;
    /**
     * 默认消息
     */
    private String defaultMessage;

    MsgSyncTimeTaskStatusEnum(int code, String defaultMessage) {
        this.code = code;
        this.defaultMessage = defaultMessage;
    }

    /**
     * 获取状态代码
     */
    public int getCode() {
        return this.code;
    }

    /**
     * 获取默认消息
     */
    public String getDefaultMessage() {
        return this.defaultMessage;
    }
}
