package com.bcxin.message.common;

/**
 * description: 常量
 * author: linchunpeng
 * date:  2023-07-14 9:52
 */
public class CommonConstant {

    /**
     * 发送类型：机器人
     */
    public static final String MSG_SEND_TYPE_ROBOT = "robot";

    /**
     * 发送类型：频道
     */
    public static final String MSG_SEND_TYPE_CHANNEL = "channel";

    /**
     * 消息类型：文本
     */
    public static final String MSG_MESSAGE_TYPE_TEXT = "text";

    /**
     * 消息类型：链接
     */
    public static final String MSG_MESSAGE_TYPE_LINK = "link";

    /**
     * 消息类型：富通知
     */
    public static final String MSG_MESSAGE_TYPE_NOTICE = "notice";

    /**
     * 目标类型：用户
     */
    public static final String MSG_TARGET_TYPE_USER = "user";

    /**
     * 目标类型：群组
     */
    public static final String MSG_TARGET_TYPE_GROUP = "group";

    /**
     * 接口请求头部appid key
     */
    public static final String MSG_REQUEST_HEADER_APPID = "appid";

    /**
     * 接口请求头部secret key
     */
    public static final String MSG_REQUEST_HEADER_SECRET = "secret";

    /**
     * 接口请求id key
     */
    public static final String MSG_REQUEST_ID = "MSG_REQUEST_ID";

    /**
     * 接口请求参数 key
     */
    public static final String MSG_REQUEST_PARAM = "MSG_REQUEST_PARAM";

    /**
     * 消息发送请求表-kafka
     */
    public static final String MSG_SEND_REQUEST_KAFKA_TOPIC="messagecenter.binlog-cdc.topic.v2.msg_send_request";

    /**
     * 群组创建表-kafka
     */
    public static final String MSG_GROUP_CREATE_KAFKA_TOPIC="messagecenter.binlog-cdc.topic.v2.msg_group_create";

    public static final String TOPIC_DEAD_LETTER_DISPATCH = "messagecenter.dead.letter.dlt.topic";
    public static final String HEADER_ORIGINAL_TOPIC_NAME = "ORIGINAL_HEADER_TOPIC_NAME";


}
