/*
 * Decompiled with CFR 0.152.
 */
package cn.wildfirechat.pojos;

import cn.wildfirechat.pojos.Conversation;
import cn.wildfirechat.pojos.MessagePayload;
import cn.wildfirechat.proto.WFCMessage;
import io.netty.util.internal.StringUtil;
import java.util.List;

public class SendMessageData {
    private String sender;
    private Conversation conv;
    private MessagePayload payload;
    private List<String> toUsers;
    private boolean isMeshMessage;
    private boolean isUserMessage;

    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public Conversation getConv() {
        return this.conv;
    }

    public void setConv(Conversation conv) {
        this.conv = conv;
    }

    public MessagePayload getPayload() {
        return this.payload;
    }

    public void setPayload(MessagePayload payload) {
        this.payload = payload;
    }

    public List<String> getToUsers() {
        return this.toUsers;
    }

    public void setToUsers(List<String> toUsers) {
        this.toUsers = toUsers;
    }

    public boolean isMeshMessage() {
        return this.isMeshMessage;
    }

    public void setMeshMessage(boolean meshMessage) {
        this.isMeshMessage = meshMessage;
    }

    public boolean isUserMessage() {
        return this.isUserMessage;
    }

    public void setUserMessage(boolean userMessage) {
        this.isUserMessage = userMessage;
    }

    public static boolean isValide(SendMessageData sendMessageData) {
        return sendMessageData != null && sendMessageData.getConv() != null && sendMessageData.getConv().getType() >= 0 && sendMessageData.getConv().getType() <= 6 && !StringUtil.isNullOrEmpty((String)sendMessageData.getConv().getTarget()) && !StringUtil.isNullOrEmpty((String)sendMessageData.getSender()) && sendMessageData.getPayload() != null;
    }

    public WFCMessage.Message toProtoMessage() {
        if (this.toUsers != null && this.toUsers.size() > 0) {
            return WFCMessage.Message.newBuilder().setFromUser(this.sender).setConversation(WFCMessage.Conversation.newBuilder().setType(this.conv.getType()).setTarget(this.conv.getTarget()).setLine(this.conv.getLine())).setContent(this.payload.toProtoMessageContent()).addAllTo(this.toUsers).build();
        }
        return WFCMessage.Message.newBuilder().setFromUser(this.sender).setConversation(WFCMessage.Conversation.newBuilder().setType(this.conv.getType()).setTarget(this.conv.getTarget()).setLine(this.conv.getLine())).setContent(this.payload.toProtoMessageContent()).build();
    }

    public static SendMessageData fromProtoMessage(WFCMessage.Message protoMessage) {
        SendMessageData data = new SendMessageData();
        data.sender = protoMessage.getFromUser();
        data.conv = new Conversation();
        data.conv.setTarget(protoMessage.getConversation().getTarget());
        data.conv.setType(protoMessage.getConversation().getType());
        data.conv.setLine(protoMessage.getConversation().getLine());
        data.payload = MessagePayload.fromProtoMessageContent(protoMessage.getContent());
        return data;
    }
}

