<%@ page contentType="text/html;charset=UTF-8" %>
<%@ page import="org.springframework.security.core.AuthenticationException" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<!DOCTYPE html>
<html>
<head>
	<%@include file="/WEB-INF/views/include/head.jsp" %>
	<link href="${ctxStatic }/css/plugins/bootstrap-table/bootstrap-table.min.css?v=${version}" rel="stylesheet">
</head>

<body class="gray-bg">
    <div class="wrapper wrapper-content animated fadeInRight">
        <div class="row">
            <div class="col-sm-12">
                <div class="ibox float-e-margins">
                    <div class="ibox-content">
                        <table id="dataTable"></table>
                    </div>
                </div>
            </div>
        </div>
    </div>
	<%@include file="/WEB-INF/views/include/foot.jsp"%>
	<script src="${ctxStatic }/js/plugins/bootstrap-table/bootstrap-table.min.js?v=${version}"></script>
	<script src="${ctxStatic }/js/plugins/bootstrap-table/locale/bootstrap-table-zh-CN.min.js?v=${version}"></script>
	<script src="${ctxStatic }/js/tablePage.js?v=${version}"></script>
	<script>
		$(function(){
			var objId = "dataTable";
			var url = ctx + "/manage/task/findTaskListForPage.json";
			var columns = [  
					 {title: 'id',field: 'oid', visible: false, align: 'center',valign: 'middle'},
					 {title: '报告',field: 'name',align: 'center',valign: 'middle',sortable: true},   
					 {title: '支付状态',field: 'reportStatus', align: 'center',valign: 'middle',sortable: true},
					 {title: '接受者',field: 'assgin',align: 'center',valign: 'middle',sortable: true},   
					 {title: '任务接受状态',field: 'acceptStatus', align: 'center',valign: 'middle',sortable: true},  
					 {title: '任务处理状态',field: 'taskStatus',align: 'center',valign: 'middle',sortable: true},    
					 {title: '任务接受时间',field: 'acceptDate',align: 'center',valign: 'middle',sortable: true},  
					 {title: '任务结束时间',field: 'finishDate', align: 'center',valign: 'middle',sortable: true},  
					 {title: '创建时间',field: 'createOn',align: 'center',valign: 'middle',sortable: true},  
					 {title: '操作',field: '#',align: 'center',  
					     formatter:function(value,row,index){    
					    	 var e ='';
					         if(row.taskStatusValue == '100')
					    	 	e = '<a class="btn btn-primary" href="'+ctx+'/manage/task/distributeTask/'+row.oid+'" target="dialog" width="960px" height="600px"><i class="fa fa-edit"></i>分配任务</a>';
					         return e;    
					     }   
					 }  
					];
			bootstrapTableDiy(objId,url,columns);

			initLayerBtnClick();
		})
	</script>

</body>
</html>
