<%@ page contentType="text/html;charset=UTF-8" %>
<%@ page import="org.springframework.security.core.AuthenticationException" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<!DOCTYPE html>
<html>
<head>
	<%@include file="/WEB-INF/views/include/head.jsp" %>
	<link href="${ctxStatic }/css/plugins/bootstrap-table/bootstrap-table.min.css?v=${version}" rel="stylesheet">
</head>

<body class="gray-bg">
    <div class="wrapper wrapper-content animated fadeInRight">
        <div class="row">
            <div class="col-sm-12">
                <div class="ibox float-e-margins">
                    <div class="ibox-content">
                        <table id="dataTable"></table>
                    </div>
                </div>
            </div>
        </div>
    </div>
	<%@include file="/WEB-INF/views/include/foot.jsp"%>
    <script src="${ctxStatic }/js/layerImg.js?v=${version}"></script>
	<script src="${ctxStatic }/js/plugins/bootstrap-table/bootstrap-table.min.js?v=${version}"></script>
	<script src="${ctxStatic }/js/plugins/bootstrap-table/locale/bootstrap-table-zh-CN.min.js?v=${version}"></script>
	<script src="${ctxStatic }/js/tablePage.js?v=${version}"></script>
	<script>
		$(function(){
			var objId = "dataTable";
			var url = ctx + "/manage/surveyReport/findReportListForPage.json";
			var columns = [  
					 {title: 'id',field: 'oid', visible: false, align: 'center',valign: 'middle'},
					 {title: '活动名称',field: 'activityName',align: 'center',valign: 'middle',sortable: true},
					 {title: '场馆名称',field: 'venueName', align: 'center',valign: 'middle',sortable: true},
					 {title: '勘查阶段',field: 'surveyStep',align: 'center',valign: 'middle',sortable: true},
					 {title: '操作',field: '#',align: 'center',
					     formatter:function(value,row,index){    
					    	 var e = '<a class="btn btn-primary" href="'+ctx+'/manage/surveyReport/reportDetail/'+row.oid+'" target="dialogDetail" width="960px" height="600px"><i class="fa fa-edit"></i>查看详情</a>';
                             e = e + '<a class="ml-10 btn btn-primary" href="'+ctx+'/manage/surveyReport/reCreateSurveyReport/'+row.oid+'" target="ajaxTodo" title="确定重发此勘查报告？"><i class="fa fa-edit"></i>重发勘查报告</a>';
					         return e;    
					     }   
					 }  
					];
			bootstrapTableDiy(objId,url,columns);

			initLayerBtnClick();
		})
	</script>

</body>
</html>
