package com.bcxin.survey.vo;

import com.bcxin.survey.enums.report.FieldType;


/**
 * 场馆字段信息
 * @author Administrator
 *
 */
public class VenueInputDto {

	private String fieldName;//字段名
	private String itemName;//字段名中文描述
	private FieldType fieldType;//字段类型
	private String type;//字段类型
	private String maxLength;//最大可输入长度
	private String options;//选项
	private String placeholder;//提示
	private String value;//值
	private boolean required = false;;
	
	public String getFieldName() {
		return fieldName;
	}
	public void setFieldName(String fieldName) {
		this.fieldName = fieldName;
	}
	public String getItemName() {
		return itemName;
	}
	public void setItemName(String itemName) {
		this.itemName = itemName;
	}
	public FieldType getFieldType() {
		return fieldType;
	}
	public void setFiledType(String filedType) {
		switch (filedType) {
		case "img":
			this.fieldType = FieldType.IMAGE;
			break;
		case "text":
			this.fieldType = FieldType.INPUT;
			break;
		case "multitext":
			this.fieldType = FieldType.TEXTAREA;
			break;
		case "datetime":
			this.fieldType = FieldType.DATE;
			break;
		case "float":
			this.fieldType = FieldType.INPUT;
			break;
		case "int":
			this.fieldType = FieldType.INPUT;
			break;
		case "checkbox":
			this.fieldType = FieldType.CHECKBOX;
			break;
		case "radio":
			this.fieldType = FieldType.RADIO;
			break;
		case "select":
			this.fieldType = FieldType.SELECT;
			break;
		default:
			this.fieldType = FieldType.INPUT;
			break;
		}
	}
	public String getMaxLength() {
		return maxLength;
	}
	public void setMaxLength(String maxLength) {
		this.maxLength = maxLength;
	}
	public String getOptions() {
		return options;
	}
	public void setOptions(String options) {
		this.options = options;
	}
	public String getPlaceholder() {
		return placeholder;
	}
	public void setPlaceholder(String placeholder) {
		this.placeholder = placeholder;
	}
	public String getType() {
		return type;
	}
	public void setType(String type) {
		this.type = type;
	}
	public String getValue() {
		return value;
	}
	public void setValue(String value) {
		this.value = value;
	}
	public boolean isRequired() {
		return required;
	}
	public void setRequired(boolean required) {
		this.required = required;
	}
	
}
