package com.bcxin.survey.utils;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;


/**
 * 临时服务机构分类工具
 * @author Ethan
 */
public class OrgTypeUtil {
	
	private static TreeMap<String, String> orgType = new TreeMap<String, String>(new Comparator<String>(){  
        public int compare(String o1, String o2) {  
            return o1.compareTo(o2);  
        }
    });  
	
	static {
		orgType.put("assessmentorg", "风险评估机构");
		orgType.put("cateringorg", "餐饮公司");
		orgType.put("explodeorg", "防爆公司");
		orgType.put("ticketorg", "票务公司");
		orgType.put("securityorg", "保安公司");
		orgType.put("siteorg", "场租公司");
		orgType.put("stageorg", "临建公司");
		orgType.put("safetycheckorg", "安检门公司");
		orgType.put("supervisororg", "监理公司");
	}
	
	public static Map<String, String> getList() {
		return orgType;
	}
	
	public static String getName(String code) {
		return orgType.get(code);
	}
	
	public static void main(String[] args) {
		for(Iterator<String> i = orgType.keySet().iterator(); i.hasNext();) {
			String key = i.next();
			System.out.print(key + ": ");
			System.out.println(orgType.get(key));
		}
	}

}
