package com.bcxin.survey.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.*;
import javax.mail.internet.*;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Properties;
import java.util.ResourceBundle;

public class EmailUtil {

    final static Logger log = LoggerFactory.getLogger(EmailUtil.class);

    //发送信件邮箱的用户名及密码
    private static String username;
    private static String password;

    //右键服务器设置
    private static String host;
    private static String from;//发件人

    private final static ResourceBundle config = ResourceBundle.getBundle("config");


    /*
     * 初始化方法
     */
    public EmailUtil() {
        host = config.getString("mail_host");
        username = config.getString("mail_from");
        password = config.getString("mail_password");
        from = config.getString("mail_from");
    }


    /**
     * 发送邮件
     *
     * @param subject
     *            邮件主题
     * @param body
     *            邮件内容
     * @param to
     *            收件人地址
     *            附件
     */
    public void sendEmail(String subject, String body, String to ,File attachment) {
        if (StringUtil.isEmpty(to)) {
            return;
        }
        if (!to.matches("[\\w\\.\\-]+@([\\w\\-]+\\.)+[\\w\\-]+")) {
            log.error("邮箱（"+to+"）校验未通过，格式不对!");
            return;
        }
        try {
            final String SSL_FACTORY = "javax.net.ssl.SSLSocketFactory";

            // 创建信件服务器
            Properties props = System.getProperties();
            props.setProperty("mail.smtp.host", host);
            props.setProperty("mail.smtp.socketFactory.class", SSL_FACTORY);
            props.setProperty("mail.smtp.socketFactory.fallback", "false");
            props.setProperty("mail.smtp.port", "465");
            props.setProperty("mail.smtp.socketFactory.port", "465");
            props.put("mail.smtp.auth", "true");
            // 得到默认的对话对象
            Authenticator a = new Authenticator() {
                @Override
                public PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(username, password);
                }
            };
            //创建Session实例
            Session session = Session.getDefaultInstance(props, a);
            //创建MimeMessage实例对象
            MimeMessage msg = new MimeMessage(session);

            //设置自定义发件人昵称
            String nick = "";
            try {
                nick = javax.mail.internet.MimeUtility.encodeText("百川信");
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            //设置发信人
            msg.setFrom(new InternetAddress(nick + " <" + from + ">"));
            //设置收信人
            msg.setRecipients(Message.RecipientType.TO, InternetAddress.parse(to));
            //设置发送日期
            msg.setSentDate(new Date());
            //设置邮件主题
            msg.setSubject(subject);
            //设置邮件正文
            // 向multipart对象中添加邮件的各个部分内容，包括文本内容和附件
            Multipart multipart = new MimeMultipart();

            // 添加邮件正文
            BodyPart contentPart = new MimeBodyPart();
            contentPart.setContent(body, "text/html;charset=UTF-8");
            multipart.addBodyPart(contentPart);

            //设置附件
            if (attachment != null) {

                // 添加附件的内容
                if (attachment != null) {
                    BodyPart attachmentBodyPart = new MimeBodyPart();
                    DataSource source = new FileDataSource(attachment);
                    attachmentBodyPart.setDataHandler(new DataHandler(source));

                    //MimeUtility.encodeWord可以避免文件名乱码
                    attachmentBodyPart.setFileName(MimeUtility.encodeWord(attachment.getName()));
                    multipart.addBodyPart(attachmentBodyPart);
                }

            }

            // 将multipart对象放到message中
            msg.setContent(multipart);
            Transport.send(msg);

            log.debug("邮件发送成功，收件人[{}]，主题[{}]，发送内容[{}]",to,subject,body);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("邮件发送失败，收件人[{}]，主题[{}]，发送内容[{}]",to,subject,body);
            log.error("邮件发送失败，异常[{}]",e.getMessage());
        }
    }


    public static void main(String[] args) {
        EmailUtil emailUtil = new EmailUtil();
        String subject = "测试邮件3";
        File file = new File("C:\\Users\\PVer\\Desktop\\nba.xlsx");
        String context = "<font color=\"#F18C1E\" style=\"font-family: '黑体';\">尊敬的客户，您好：</font><br>&nbsp;&nbsp;&nbsp;&nbsp;"
                + "<p style=\"text-indent:2em;\">请勿回复本邮件.点击下面的链接,重设邮箱&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</p><p style=\"text-indent:2em;\"><a href="
                + " target='_BLANK'>点击我重新设置邮箱</a></p>"
                + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<p style=\"text-indent:2em;\">提示:本邮件超过30分钟,链接将会失效，需要重新申请'重设邮箱'。</p>"
                + "<p style=\"text-indent:2em;\">如有疑问请及时致电4009979696进行咨询。</p>";
        emailUtil.sendEmail(subject, context, "304607162@qq.com", file);
    }

}
