package com.bcxin.survey.utils;

import com.bcxin.survey.enums.report.BenefitPeriodType;
import org.joda.time.DateTime;
import org.joda.time.Interval;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


public class DateUtil {
	public static final String FORMAT1 = "yyyy-MM-dd HH:mm:ss";
	public static final String FORMAT2 = "yyyy-MM-dd";
	public static final String FORMAT3 = "MM/dd/yyyy HH:mm:ss";
	public static final String FORMAT4 = "MM/dd/yyyy";
	public static final String FORMAT5 = "HH:mm:ss";
	public static final String FORMAT6 = "yyyy/MM/dd";
	public static final String FORMAT7 = "yyyy-MM-dd HH:mm";
	public static final String FORMAT8 ="yyyyMMddhhmmss";
	/**
	 * 年
	 */
	public static final int DATATYPE_YEAR = 1;

	/**
	 * 月
	 */
	public static final int DATATYPE_MONTH = 2;

	/**
	 * 日
	 */
	public static final int DATATYPE_DAY = 3;

	/**
	 * 小时
	 */
	public static final int DATATYPE_HOUR = 4;

	/**
	 * 分钟
	 */
	public static final int DATATYPE_MINUTE = 5;

	/**
	 * 秒
	 */
	public static final int DATATYPE_SECOND = 6;

	private DateUtil() {
	}

	/**
	 * 根据string日期获取其格式
	 * 
	 * @param date
	 * @return
	 * @throws Exception
	 */
	public static String getFormat(String date) throws Exception {
		String reg1 = "\\d{4}-\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}(.\\d{1,3}){0,1}";
		String reg2 = "\\d{4}-\\d{1,2}-\\d{1,2}";
		String reg3 = "\\d{1,2}/\\d{1,2}/\\d{4} \\d{1,2}:\\d{1,2}:\\d{1,2}(.\\d{1,3}){0,1}";
		String reg4 = "\\d{1,2}/\\d{1,2}/\\d{4}";
		String reg5 = "\\d{4}-\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}";
		if (date.matches(reg1)) {
			return FORMAT1;
		} else if (date.matches(reg2)) {
			return FORMAT2;
		} else if (date.matches(reg3)) {
			return FORMAT3;
		} else if (date.matches(reg4)) {
			return FORMAT4;
		} else if (date.matches(reg5)) {
			return FORMAT7;
		}else {
			throw new Exception("不支持的日期格式：" + date);
		}
	}

	/**
	 * 获取当前日期
	 * 
	 * @return
	 */
	public static String getCurrentDate() {
		return getCurrentDateTime(FORMAT2);
	}

	/**
	 * 获取当前日期
	 * 
	 * @return
	 */
	public static String getCurrentDate(String format) {
		return getCurrentDateTime(format);
	}

	/**
	 * 获取当前时间
	 * 
	 * @return 时分秒
	 */
	public static String getCurrentTime() {
		return getCurrentDateTime(FORMAT5);
	}

	/**
	 * 获取当前日期时间
	 * 
	 * @return
	 */
	public static String getCurrentDateTime() {
		return getCurrentDateTime(FORMAT1);
	}


	/**
	 * 获取当前日期yyyymmddhhmmss
	 *
	 * @return
	 */
	public static String getTimestamp() {
		return getCurrentDateTime(FORMAT8);
	}

	/**
	 * 根据特定格式获取当前时间
	 * 
	 * @param format
	 * @return
	 */
	public static String getCurrentDateTime(String format) {
		SimpleDateFormat df = new SimpleDateFormat(format);
		return df.format(new Date());
	}

	/**
	 * 获取昨天日期
	 * 
	 * @return yyyy-MM-dd
	 */
	public static String getYesterday() {
		SimpleDateFormat df = new SimpleDateFormat(FORMAT2);
		Calendar c = Calendar.getInstance();
		c.add(Calendar.DATE, -1);
		return df.format(c.getTime());
	}

	/**
	 * 获取明天日期
	 * 
	 * @return yyyy-MM-dd
	 */
	public static String getTomorrow() {
		SimpleDateFormat df = new SimpleDateFormat(FORMAT2);
		Calendar c = Calendar.getInstance();
		c.add(Calendar.DATE, 1);
		return df.format(c.getTime());
	}

	/**
	 * String转换date
	 * 
	 * @param date
	 * @return
	 * @throws Exception
	 */
	public static Date convertStringToDate(String date) {
		SimpleDateFormat df;
		try {
			df = new SimpleDateFormat(getFormat(date));
			return df.parse(date);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return new Date();
	}

	public static String convertDateToString(Date date, String format) {
		SimpleDateFormat df = new SimpleDateFormat(format);
		return df.format(date);
	}

	public static String dateFormat(String value, String format) {
		try {
			Date date = convertStringToDate(value);
			return convertDateToString(date, format);
		} catch (Exception e) {
			return "";
		}
	}

	public static int dateDiff(int type, String sdate1, String sdate2)
			throws Exception {
		Date date1 = new SimpleDateFormat(getFormat(sdate1)).parse(sdate1);
		Date date2 = new SimpleDateFormat(getFormat(sdate2)).parse(sdate2);
		Calendar cal1 = Calendar.getInstance();
		Calendar cal2 = Calendar.getInstance();
		cal1.setTime(date1);
		cal2.setTime(date2);
		int yearDiff = cal2.get(Calendar.YEAR) - cal1.get(Calendar.YEAR);
		if (type == DATATYPE_YEAR) {
			return yearDiff;
		} else if (type == DATATYPE_MONTH) {
			int monthDiff = yearDiff * 12 + cal2.get(Calendar.MONTH)
					- cal1.get(Calendar.MONTH);
			return monthDiff;
		}else if(type == DATATYPE_DAY){
			return dateDiff(date2,date1);
		}else {
			long ldate1 = date1.getTime() + cal1.get(Calendar.ZONE_OFFSET)
					+ cal1.get(Calendar.DST_OFFSET);
			long ldate2 = date2.getTime() + cal2.get(Calendar.ZONE_OFFSET)
					+ cal2.get(Calendar.DST_OFFSET);
			if (type == DATATYPE_HOUR) {
				return (int) ((ldate2 - ldate1) / (3600000));
			} else if (type == DATATYPE_MINUTE) {
				return (int) ((ldate2 - ldate1) / (60000));
			} else if (type == DATATYPE_SECOND) {
				return (int) ((ldate2 - ldate1) / (1000));
			} else {
				return (int) ((ldate2 - ldate1) / (3600000 * 24));
			}
		}
	}
	/**  
     * 计算两个日期之间相差的天数  
     * @param smdate 较小的时间 
     * @param bdate  较大的时间 
     * @return 相差天数 
     * @throws ParseException  
     */    
    public static int dateDiff(Date smdate,Date bdate)   
    {    
        SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd");  
        try {
			smdate=sdf.parse(sdf.format(smdate));
			bdate=sdf.parse(sdf.format(bdate));  
		} catch (ParseException e) {
			e.printStackTrace();
		}  
        Calendar cal = Calendar.getInstance();    
        cal.setTime(smdate);    
        long time1 = cal.getTimeInMillis();                 
        cal.setTime(bdate);    
        long time2 = cal.getTimeInMillis();         
        long between_days=(time2-time1)/(1000*3600*24);  
       return Integer.parseInt(String.valueOf(between_days));           
    }    

	public static String dateAdd(int type, String sdate, int num)
			throws Exception {
		SimpleDateFormat df = new SimpleDateFormat(getFormat(sdate));
		Date date = df.parse(sdate);
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		if (type == DATATYPE_YEAR) {
			cal.add(Calendar.YEAR, num);
		} else if (type == DATATYPE_MONTH) {
			cal.add(Calendar.MONTH, num);
		} else if (type == DATATYPE_HOUR) {
			cal.add(Calendar.HOUR, num);
		} else if (type == DATATYPE_MINUTE) {
			cal.add(Calendar.MINUTE, num);
		} else if (type == DATATYPE_SECOND) {
			cal.add(Calendar.SECOND, num);
		} else {
			cal.add(Calendar.DATE, num);
		}
		return df.format(cal.getTime());
	}

	public static int calAge(String birthday, String type) throws Exception {
		String currDate = getCurrentDate();
		if ("D".equalsIgnoreCase(type)) {
			return dateDiff(DATATYPE_DAY, birthday, currDate);
		} else if ("M".equalsIgnoreCase(type)) {
			int result = dateDiff(DATATYPE_MONTH, birthday, currDate);
			String temp = dateAdd(DATATYPE_MONTH, birthday, result);
			if (dateDiff(DATATYPE_DAY, temp, currDate) <= 0) {
				result--;
			}
			return result;
		} else {
			int result = dateDiff(DATATYPE_YEAR, birthday, currDate);
			String temp = dateAdd(DATATYPE_YEAR, birthday, result);
			if (dateDiff(DATATYPE_DAY, temp, currDate) <= 0) {
				result--;
			}
			return result;
		}
	}

	public static int getYearOfDate(Date date) {
		Calendar gc = prepare(date);
		return gc.get(Calendar.YEAR);
	}

	public static int getMonthOfDate(Date date) {
		Calendar gc = prepare(date);
		return gc.get(Calendar.MONTH);
	}

	public static int getDayOfDate(Date date) {
		Calendar gc = prepare(date);
		return gc.get(Calendar.DAY_OF_MONTH);
	}

	public static Date addYear(Date date, int year) {
		Calendar gc = prepare(date);
		gc.add(Calendar.YEAR, year);
		return gc.getTime();
	}

	public static Date addMonth(Date date, int month) {
		Calendar gc = prepare(date);
		gc.add(Calendar.MONTH, month);
		return gc.getTime();
	}

	public static Date addDay(Date date, int day) {
		Calendar gc = prepare(date);
		gc.add(Calendar.DAY_OF_MONTH, day);
		return gc.getTime();
	}

	public static Date addPeriod(Date date, BenefitPeriodType type, int period) {

		Calendar gc = prepare(date);
		switch (type) {
		case ANNUAL:
			gc.add(Calendar.YEAR, period);
			break;
		case MONTHLY:
			gc.add(Calendar.MONTH, period);
			break;
		default:
			gc.add(Calendar.DAY_OF_MONTH, period);
			break;
		}

		return addDay(gc.getTime(), -1);
	}

	private static Calendar prepare(Date date) {
		Calendar gc = Calendar.getInstance();
		gc.setTime(date);
		return gc;
	}

	public static Date rollingDate(Date date, int field, int amount) {
		Calendar gc = prepare(date);
		gc.roll(field, amount);
		return gc.getTime();
	}

	public static boolean timestampIntervalIntersection(Date firstStart,
			Date firstEnd, Date twoStart, Date twoEnd) {
		if (firstStart.after(twoStart) && firstStart.before(twoEnd))
			return true;
		if (firstEnd.after(twoStart) && firstEnd.before(twoEnd))
			return true;
		if (firstStart.equals(twoStart) || firstStart.equals(twoEnd))
			return true;
		if (firstEnd.equals(twoStart) || firstEnd.equals(twoEnd))
			return true;
		if (firstStart.before(twoStart) && firstEnd.after(twoEnd))
			return true;
		return false;
	}

	/**
	 * Limited version of Calendar.set.
	 * <p>
	 * Set the specified field to min(actual maximum value of this field,
	 * specified new value).
	 * </p>
	 * 
	 * @param date
	 *            base date.
	 * @param field
	 *            field want to modify.
	 * @param value
	 *            the new value of specified field.
	 * @return a new Date instance holding the new value.
	 */
	public static Date setFieldInLimit(Date date, int field, int value) {
		Calendar gc = prepare(date);
		gc.set(field, Math.min(gc.getActualMaximum(field), value));
		return gc.getTime();
	}

	public static Date parseDate(String value) {
		Date date = java.sql.Date.valueOf(value);
		return date;
	}

	public static Date getDayStart(Date currentDate) {
		Date result = null;

		Calendar current = Calendar.getInstance();
		current.setTime(currentDate);
		current.set(Calendar.HOUR_OF_DAY, 0);
		current.clear(Calendar.MILLISECOND);
		current.clear(Calendar.MINUTE);
		current.clear(Calendar.SECOND);
		result = current.getTime();

		return result;
	}

	public static Date getDayEnd(Date day) {
		Date result = null;

		Calendar date = Calendar.getInstance();
		date.setTime(day);
		date.set(Calendar.HOUR_OF_DAY, 24);
		date.clear(Calendar.MINUTE);
		date.clear(Calendar.SECOND);
		date.set(Calendar.MILLISECOND, -1);
		result = date.getTime();

		return result;
	}

	public static Date getTodayStart() {
		return getDayStart(new Date());
	}

	public static Date getTodayEnd() {
		return getDayEnd(new Date());
	}

	public static Date getWeekStart() {
		Date result = null;

		Calendar current = Calendar.getInstance();
		current.set(Calendar.HOUR_OF_DAY, 0);
		current.clear(Calendar.MILLISECOND);
		current.clear(Calendar.MINUTE);
		current.clear(Calendar.SECOND);
		current.set(Calendar.DAY_OF_WEEK, current.getFirstDayOfWeek());
		result = current.getTime();

		return result;
	}

	public static Date getWeekEnd() {
		Date result = null;

		Calendar current = Calendar.getInstance();
		current.setTime(getWeekStart());
		current.add(Calendar.WEEK_OF_YEAR, 1);
		current.set(Calendar.MILLISECOND, -1);
		result = current.getTime();

		return result;
	}

	public static Date getMonthStart(Date currentDate) {
		Date result = null;

		Calendar current = Calendar.getInstance();
		current.setTime(getDayStart(currentDate));
		current.set(Calendar.DAY_OF_MONTH, 1);
		result = current.getTime();

		return result;
	}

	public static Date getYearStart(Date date) {
		int year = getYearOfDate(date);
		Calendar result = Calendar.getInstance();
		result.set(year, 0, 1);
		return result.getTime();
	}

	/**
	 * Return a Date representing the start of the specified month.
	 * 
	 * @param year
	 *            Year value.
	 * @param month
	 *            Month value. Starts from 0.
	 * @return
	 */
	public static Date getMonthStart(int year, int month) {
		Calendar sampleDate = Calendar.getInstance();
		sampleDate.set(Calendar.YEAR, year);
		sampleDate.set(Calendar.MONTH, month);
		return getMonthStart(sampleDate.getTime());
	}

	public static Date getMonthEnd(Date currentDate) {
		Date result = null;

		Calendar current = Calendar.getInstance();
		current.setTime(getMonthStart(currentDate));
		current.add(Calendar.MONTH, 1);
		current.add(Calendar.MILLISECOND, -1);
		result = current.getTime();

		return result;
	}

	/**
	 * Return a Date representing the end of the specified month.
	 * 
	 * @param year
	 *            Year value.
	 * @param month
	 *            Month value. Starts from 0.
	 * @return
	 */
	public static Date getMonthEnd(int year, int month) {
		Calendar sampleDate = Calendar.getInstance();
		sampleDate.set(Calendar.YEAR, year);
		sampleDate.set(Calendar.MONTH, month);
		return getMonthEnd(sampleDate.getTime());
	}

	public static int calculateDisparity(Date beforeDate, Date afterDate,
			int calendar_time_type, int roundingMode) {
		int result = 0;

		if (beforeDate == null || afterDate == null) {
			throw new IllegalArgumentException(
					"beforeDate and afterDate can not be null.");
		}
		if (calendar_time_type == Calendar.DATE)
			throw new IllegalArgumentException(
					"Calendar.Date is not supported now.");

		Calendar after = prepare(afterDate);
		Calendar before = prepare(beforeDate);

		// int yearDisparity = after.get(Calendar.YEAR) -
		// before.get(Calendar.YEAR);
		// int monthDisparity = after.get(Calendar.MONTH) -
		// before.get(Calendar.MONTH);
		// switch (calendar_time_type) {
		// case Calendar.YEAR:
		// result = yearDisparity + monthDisparity / 12;
		// break;
		// case Calendar.MONTH:
		// result = yearDisparity * 12 + monthDisparity;
		// break;
		// default:
		// // throw exception
		// }

		if (calendar_time_type == Calendar.DATE) {
			result -= before.get(Calendar.DAY_OF_YEAR);
			while (before.before(after)) {
				result += before.getActualMaximum(Calendar.DAY_OF_YEAR);
				before.add(Calendar.YEAR, 1);
			}
			result += before.get(Calendar.DAY_OF_YEAR);
		} else {
			if (roundingMode == BigDecimal.ROUND_DOWN) {
				result = -1;
				while (!before.after(after)) {
					result++;
					before.add(calendar_time_type, 1);
				}
			} else if (roundingMode == BigDecimal.ROUND_UP) {
				result = 0;
				while (before.before(after)) {
					result++;
					before.add(calendar_time_type, 1);
				}
			}
		}

		return result;
	}

	public static Date mergeDate(Date day, Date time) {
		Calendar result = Calendar.getInstance();

		result.setTime(time);
		Calendar dayHelper = Calendar.getInstance();
		dayHelper.setTime(day);
		result.set(dayHelper.get(Calendar.YEAR), dayHelper.get(Calendar.MONTH),
				dayHelper.get(Calendar.DATE));

		return result.getTime();
	}

	/**
	 * Get a Iterator of a Date collection which is [start, end].
	 * 
	 * @param start
	 * @param end
	 * @return a Date Iterator.
	 */
	public static Iterator dateIterator(Date start, Date end) {
		return new DateIterator(start, end);
	}

	/**
	 * Get a Iterator of a Calendar collection which is [start, end].
	 * 
	 * @param start
	 * @param end
	 * @return a Calendar Iterator.
	 */
	public static Iterator calendarIterator(Calendar start, Calendar end) {
		return new CalendarIterator(start, end);
	}

	/**
	 * from org.apache.commons.lang.time.DateUtils.DateIterator. Renamed.
	 * 
	 * @author �ų�
	 * @version 1.0 created on 2007-6-30
	 */
	static class CalendarIterator implements Iterator {
		private final Calendar endFinal;

		private final Calendar spot;

		/**
		 * Constructs a DateIterator that ranges from one date to another.
		 * 
		 * @param startFinal
		 *            start date (inclusive)
		 * @param endFinal
		 *            end date (not inclusive)
		 */
		CalendarIterator(Calendar startFinal, Calendar endFinal) {
			super();
			this.endFinal = endFinal;
			spot = startFinal;
			spot.add(Calendar.DATE, -1);
		}

		/**
		 * Has the iterator not reached the end date yet?
		 * 
		 * @return <code>true</code> if the iterator has yet to reach the end
		 *         date
		 */
		public boolean hasNext() {
			return spot.before(endFinal);
		}

		/**
		 * Return the next calendar in the iteration
		 * 
		 * @return Object calendar for the next date
		 */
		public Object next() {
			if (spot.equals(endFinal)) {
				throw new NoSuchElementException();
			}
			spot.add(Calendar.DATE, 1);
			return spot.clone();
		}

		/**
		 * Always throws UnsupportedOperationException.
		 * 
		 * @throws UnsupportedOperationException
		 * @see java.util.Iterator#remove()
		 */
		public void remove() {
			throw new UnsupportedOperationException();
		}
	}

	/**
	 * Date version.
	 * 
	 * @author �ų�
	 * @version 1.0 created on 2007-6-30
	 */
	static class DateIterator extends CalendarIterator implements Iterator {

		/**
		 * Constructs a DateIterator that ranges from one date to another.
		 * 
		 * @param startFinal
		 *            start date (inclusive)
		 * @param endFinal
		 *            end date (not inclusive)
		 */
		DateIterator(Date startFinal, Date endFinal) {
			super(prepare(startFinal), prepare(endFinal));
		}

		/**
		 * Return the next calendar in the iteration
		 * 
		 * @return Object calendar for the next date
		 */
		public Object next() {
			return ((Calendar) super.next()).getTime();
		}

	}

	public static boolean isInThePeriod(Date asOfDate, Date start, Date end) {
		if (!asOfDate.before(start) && !asOfDate.after(end))
			return true;
		return false;
	}

	/**
	 * input param formate like "2005-10-1"
	 * 
	 * @return
	 * @throws ParseException
	 */
	public static int getLastDayOfMonth(String date) throws ParseException {
		DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
		formatter.format(formatter.parse(date));
		Calendar c = formatter.getCalendar();
		int day = c.getActualMaximum(Calendar.DATE);
		return day;
	}

	public static boolean isSameDay(Date one, Date two) {
		if (getYearOfDate(one) == getYearOfDate(two)
				&& getMonthOfDate(one) == getMonthOfDate(two)
				&& getDayOfDate(one) == getDayOfDate(two)) {
			return true;
		}
		return false;
	}

	public static boolean isFirstDateOfMonth(Date date) {
		int day = date.getDate();
		if (day == 1)
			return true;
		return false;
	}

	public static boolean isFirstDayFromThisMonth(Date date) {
		Date today = new Date();

		if ((today.before(date) || today.equals(date))
				&& isFirstDateOfMonth(date))
			return true;

		return false;
	}

	public static boolean isFirstDayFromNextMonth(Date date) {
		Date today = new Date();

		if (today.before(date) && isFirstDateOfMonth(date)) {
			if (today.getMonth() == date.getMonth())
				return false;
			else
				return true;
		}

		return false;
	}

	public static boolean laterThanToday(Date effectiveDate) {
		Date today = DateUtil.getTodayStart();
		if (today.before(effectiveDate) || today.equals(effectiveDate))
			return true;
		return false;
	}

	public static boolean laterThanFirstDayOfThisMonth(Date effectiveDate) {
		Date firstDayOfThisMonth = getMonthStart(new Date());
		if (firstDayOfThisMonth.before(effectiveDate)
				|| firstDayOfThisMonth.equals(effectiveDate))
			return true;
		return false;
	}

	/**
	 * �ж������ַ��Ƿ�Ϸ�,�ƶ���ʽΪ��yyyyMM��,��Ҫ���ڵ���������ڸ�ʽУ�顣
	 * 
	 * @param externalReference
	 * @return
	 */
	public static boolean isValidFormat(String externalReference) {
		boolean isValid = true;

		Integer year = new Integer(0);
		Integer month = new Integer(0);
		if (externalReference.length() == 6) {
			try {
				year = Integer.valueOf(externalReference.substring(0, 4));
				month = Integer.valueOf(externalReference.substring(4));
			} catch (Exception e) {
				isValid = false;
			}
		} else {
			isValid = false;
		}
		if (year.intValue() < 1970 || year.intValue() > 2099
				|| month.intValue() > 12 || month.intValue() < 1) {
			isValid = false;
		}

		return isValid;
	}

	/**
	 * @param date1
	 *            ��Ҫ�Ƚϵ�ʱ�� ����Ϊ��(null),��Ҫ��ȷ�����ڸ�ʽ
	 * @param date2
	 *            ���Ƚϵ�ʱ��
	 * @param stype
	 *            ����ֵ���� 0Ϊ�����죬1Ϊ���ٸ��£�2Ϊ������
	 * @return
	 */
	public static int compareDate(Date date1, Date date2, int stype) {
		int n = 0;

		String[] u = { "��", "��", "��" };
		Calendar c1 = Calendar.getInstance();
		Calendar c2 = Calendar.getInstance();
		try {
			c1.setTime(date1);
			c2.setTime(date2);
		} catch (Exception e3) {
			System.out.println("wrong occured");
		}
		while (!c1.after(c2)) { // ѭ���Աȣ�ֱ����ȣ�n ������Ҫ�Ľ��
			n++;
			if (stype == 1) {
				c1.add(Calendar.MONTH, 1); // �Ƚ��·ݣ��·�+1
			} else {
				c1.add(Calendar.DATE, 1); // �Ƚ���������+1
			}
		}
		n = n - 1;
		if (stype == 2) {
			n = (int) n / 365;
		}
		System.out.println(date1 + " -- " + date2 + " ������" + u[stype] + ":"
				+ n);
		return n;
	}

	/**
	 * 将日期格式字符串（yyyy-MM-dd,yyyyMMdd,yyyy/MM/dd,yyyy.MM.dd）转换成Date
	 * 
	 * @param date
	 * @return
	 * @throws ParseException
	 */
	public static Date getDate(String date) throws ParseException {
		SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
		String dateValue = marsalDate(date);
		if (StringUtil.isNotEmpty(dateValue))
			return dateFormat.parse(dateValue);
		else
			return null;
	}

	/**
	 * String  转date
	 * @param date
	 * @return
	 * @throws ParseException
	 */
	public static Date getDateByString(String date) throws ParseException{
		SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");//小写的mm表示的是分钟  
	  
		Date d=sdf.parse(date);  
		return d;
	}
	/**
	 * 将日期格式字符串（yyyy-MM-dd,yyyyMMdd,yyyy/MM/dd,yyyy.MM.dd）转换成Date
	 * 
	 * @param date
	 * @return
	 * @throws ParseException
	 */
	public static Date getDate(String date, String format)
			throws ParseException {
		System.out.println(date);
		SimpleDateFormat dateFormat = new SimpleDateFormat(format);
		String dateValue = marsalDate(date);
		if (StringUtil.isNotEmpty(dateValue))
			return dateFormat.parse(dateValue);
		else
			return null;
	}

	public static Date StingToDate(String dateValue) throws ParseException {
		SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
		if (StringUtil.isNotEmpty(dateValue))
			return dateFormat.parse(dateValue);
		else
			return null;
	}

	/**
	 * 将字符串（格式:yyyy-MM-dd,yyyyMMdd,yyyy/MM/dd,yyyy.MM.dd）转换成日期格式（yyyy-MM-dd）字符串
	 * 
	 * @param date
	 * @return
	 */
	public static String marsalDate(String date) {
		date = date.replace("年", "-").replace("月", "-").replace("日", "");
		String split = "./-\t\\s";
		String dateTemp;
		String year;
		String month;
		String day;
		if (date.length() <= 10) {
			StringTokenizer tokenizer = new StringTokenizer(date, split);
			int tokenCount = tokenizer.countTokens();
			if (tokenCount == 3) {
				year = tokenizer.nextToken();
				month = tokenizer.nextToken();
				day = tokenizer.nextToken();
			} else if (tokenCount == 1) {
				dateTemp = tokenizer.nextToken();
				if (dateTemp.length() == 8) {
					year = dateTemp.substring(0, 4);
					month = dateTemp.substring(4, 6);
					day = dateTemp.substring(6, 8);
				} else if (dateTemp.length() == 6) {
					year = dateTemp.substring(0, 4);
					month = dateTemp.substring(4, 5);
					day = dateTemp.substring(5, 6);
				} else {
					return null;
				}
			} else {
				return null;
			}
			return marsalDate(year, month, day);
		} else {
			return null;
		}
	}

	/**
	 * 将year, month, day 组成日期格式（yyyy-MM-dd）字符串
	 * 
	 * @param year
	 * @param month
	 * @param day
	 * @return date
	 */
	public static String marsalDate(String year, String month, String day) {
		String date;
		String yearTemp;
		String monthTemp;
		String dayTemp;

		if (year.length() != 4 || month.length() > 2 || day.length() > 2)
			return null;

		yearTemp = year;

		if (month.length() == 1) {
			monthTemp = "0" + month;
		} else {
			monthTemp = month;
		}

		if (day.length() == 1) {
			dayTemp = "0" + day;
		} else {
			dayTemp = day;
		}
		date = yearTemp + "-" + monthTemp + "-" + dayTemp;
		return date;
	}

	/**
	 * 校验日期格式yyyy-MM-dd
	 * 
	 * @param date
	 * @return
	 */
	public static boolean checkIsValidDateFormat(String date) {
		if (date == null)
			return false;
		else if (date.length() != 10)
			return false;
		else {
			String regex = "((\\d{2}(([02468][048])|([13579][26]))[\\-\\s]?((((0?[13578])|(1[02]))[\\-\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\s]?((((0?[13578])|(1[02]))[\\-\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))";
			Pattern pattern = Pattern.compile(regex);
			Matcher mather = pattern.matcher(date);
			return mather.matches();
		}
	}

	/**
	 * 24小时制时间格式校验（HH:mm:ss）
	 * 
	 * @param dateTime
	 * @return
	 */
	public static boolean checkIsValidDateTimeFormat(String dateTime) {
		if (dateTime == null)
			return false;
		else if (dateTime.length() != 8)
			return false;
		else {
			String regex = "^(([0|1][0-9])|(2[0-3])):[0-5][0-9]:[0-5][0-9]$";
			Pattern pattern = Pattern.compile(regex);
			Matcher mather = pattern.matcher(dateTime);
			return mather.matches();
		}
	}

	/**
	 * 校验日期格式（yyyy-MM-dd,yyyyMMdd,yyyy/MM/dd,yyyy.MM.dd）
	 * 
	 * @param date
	 * @return
	 */
	public static boolean checkDate(String date) {
		String dateValue = marsalDate(date);
		return checkIsValidDateFormat(dateValue);
	}

	public synchronized static String generatorRadomNumber() {
		Date today = new Date();
		SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
		String serialNumber = format.format(today)
				+ new DecimalFormat("0000").format(new Random().nextInt(10000));

		return serialNumber;
	}

	public synchronized static String generatorRadomNumberForDate() {
		Date today = new Date();
		SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
		String serialNumber = format.format(today);
		return serialNumber;
	}

	/**
	 * 获取两日期相减的天数
	 * 
	 * @param startDate
	 * @param endDate
	 * @return
	 */
	public static int getDistDates(Date startDate, Date endDate) {
		if (null == startDate || null == endDate) {
			return -1;
		}
		long intervalMilli = endDate.getTime() - startDate.getTime();
		return (int) (intervalMilli / (24 * 60 * 60 * 1000));
	}

	public static boolean contains(Date startDate, Date endDate, Date date) {
		if (startDate == null || endDate == null || date == null)
			return false;

		Interval interval = new Interval(new DateTime(startDate), new DateTime(
				endDate).plusDays(1));

		return interval.contains(new DateTime(date));
	}

	public static String getDays(String activityStateDate,
			String activityEndDate) {
		try {
			Date startDate = DateUtil.convertStringToDate(activityStateDate);
			Date endDate = DateUtil.convertStringToDate(activityEndDate);

		} catch (Exception e) {

			e.printStackTrace();
		}
		return null;
	}

	public static String TimeDiff(String pBeginTime, String pEndTime) {
		try {
			SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd hh:mm");
			Long beginL;
			beginL = format.parse(pBeginTime).getTime();

			Long endL = format.parse(pEndTime).getTime();
			Long day = (endL - beginL) / 86400000;
			Long hour = ((endL - beginL) % 86400000) / 3600000;
			Long min = ((endL - beginL) % 86400000 % 3600000) / 60000;
			// return ("实际请假" + day + "小时" + hour + "分钟" + min);
			if (day > 0) {
				return "" + day + 1;
			}
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "0";
	}

    /**
     * 当天的开始时间
     * @return
     */
    public static Date startOfTodDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        calendar.set(Calendar.MILLISECOND, 0);
        Date date=calendar.getTime();
        return date;
    }
    /**
     * 当天的结束时间
     * @return
     */
    public static Date endOfTodDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.HOUR_OF_DAY, 23);
        calendar.set(Calendar.MINUTE, 59);
        calendar.set(Calendar.SECOND, 59);
        calendar.set(Calendar.MILLISECOND, 999);
        Date date=calendar.getTime();
        return date;
    }
    /**
     * 昨天的开始时间
     * @return
     */
    public static long startOfyesterday() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        calendar.add(Calendar.DATE, -1);
        calendar.set(Calendar.MILLISECOND, 0);
        Date date=calendar.getTime();
        return date.getTime();
    }
    /**
     * 昨天的结束时间
     * @return
     */
    public static long endOfyesterday() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.HOUR_OF_DAY, 23);
        calendar.set(Calendar.MINUTE, 59);
        calendar.set(Calendar.SECOND, 59);
        calendar.set(Calendar.MILLISECOND, 999);
        calendar.add(Calendar.DATE, -1);
        Date date=calendar.getTime();
        return date.getTime();
    }
    /**
     * 功能：获取上周的开始时间
     */
    public static long startOfLastWeek() {// 当周开始时间
        return startOfThisWeek() - 7 * 24 * 60 * 60 * 1000;
    }
    /**
     * 功能：获取上周的结束时间
     */
    public static long endOfLastWeek() {// 当周开始时间
        return endOfThisWeek() - 7 * 24 * 60 * 60 * 1000;
    }
    /**
     * 功能：获取本周的开始时间 示例：2013-05-13 00:00:00
     */
    public static long startOfThisWeek() {// 当周开始时间
        Calendar currentDate = Calendar.getInstance();
        currentDate.setFirstDayOfWeek(Calendar.MONDAY);
        currentDate.set(Calendar.HOUR_OF_DAY, 0);
        currentDate.set(Calendar.MINUTE, 0);
        currentDate.set(Calendar.SECOND, 0);
        currentDate.set(Calendar.MILLISECOND, 0);
        currentDate.set(Calendar.DAY_OF_WEEK, Calendar.MONDAY);
        Date date=currentDate.getTime();
        return date.getTime();
    }
    /**
     * 功能：获取本周的结束时间 示例：2013-05-19 23:59:59
     */
    public static long endOfThisWeek() {// 当周结束时间
        Calendar currentDate = Calendar.getInstance();
        currentDate.setFirstDayOfWeek(Calendar.MONDAY);
        currentDate.set(Calendar.HOUR_OF_DAY, 23);
        currentDate.set(Calendar.MINUTE, 59);
        currentDate.set(Calendar.SECOND, 59);
        currentDate.set(Calendar.MILLISECOND, 999);
        currentDate.set(Calendar.DAY_OF_WEEK, Calendar.SUNDAY);
        Date date=currentDate.getTime();
        return date.getTime();
    }
    /**
     * 功能：获取本月的开始时间
     */
    public static long startOfThisMonth() {// 当周开始时间
        Calendar currentDate = Calendar.getInstance();
        currentDate.set(Calendar.HOUR_OF_DAY, 0);
        currentDate.set(Calendar.MINUTE, 0);
        currentDate.set(Calendar.SECOND, 0);
        currentDate.set(Calendar.MILLISECOND, 0);
        currentDate.set(Calendar.DAY_OF_MONTH, 1);
        Date date=currentDate.getTime();
        return date.getTime();
    }
    public static long endOfThisMonth() {
        Calendar cal = Calendar.getInstance();
        cal.set(Calendar.DAY_OF_MONTH, 1);
        cal.set(Calendar.HOUR_OF_DAY, 23);
        cal.set(Calendar.MINUTE, 59);
        cal.set(Calendar.SECOND, 59);
        cal.set(Calendar.MILLISECOND, 999);
        cal.add(Calendar.MONTH, 1);
        cal.add(Calendar.DATE, -1);
        Date date=cal.getTime();
        return date.getTime();
    }
    /**
     * 功能：获取上月的开始时间
     */
    public static long startOfLastMonth() {// 当周开始时间
        Calendar currentDate = Calendar.getInstance();
        currentDate.set(Calendar.HOUR_OF_DAY, 0);
        currentDate.set(Calendar.MINUTE, 0);
        currentDate.set(Calendar.SECOND, 0);
        currentDate.set(Calendar.MILLISECOND, 0);
        currentDate.set(Calendar.DAY_OF_MONTH, 1);
        currentDate.add(Calendar.MONTH, -1);
        Date date=currentDate.getTime();
        return date.getTime();
    }
    /**
     * 功能：获取上月的结束时间
     */
    public static long endOfLastMonth() {
        Calendar cal = Calendar.getInstance();
        cal.set(Calendar.DAY_OF_MONTH, 1);
        cal.set(Calendar.HOUR_OF_DAY, 23);
        cal.set(Calendar.MINUTE, 59);
        cal.set(Calendar.SECOND, 59);
        cal.set(Calendar.MILLISECOND, 999);
        cal.add(Calendar.DATE, -1);
        Date date=cal.getTime();
        return date.getTime();
    }
    /**
     *  根据long返回year
     * @param milliseconds
     * @return
     */
    public static Object[] theYearOfTime(long milliseconds){
        Calendar cal = Calendar.getInstance();
        Date date=cal.getTime();
        int thisYear=date.getYear()+1900;
        cal.setTimeInMillis(milliseconds);
        date=cal.getTime();
        int regirsterYear=date.getYear()+1900;
        if(regirsterYear<thisYear){
            List<Integer> yearL=new ArrayList<Integer>();
            for(int i=regirsterYear;i<=thisYear;i++){
                yearL.add(i);
            }
            return yearL.toArray();
        }else{
            return new Object[]{thisYear};
        }
    }
    /**
     * 功能：获取本年的开始时间
     */
    public static long startOfTheYear(int year) {// 当周开始时间
        Calendar currentDate = Calendar.getInstance();
        currentDate.set(Calendar.YEAR, year);
        currentDate.set(Calendar.MONTH, 0);
        currentDate.set(Calendar.HOUR_OF_DAY, 0);
        currentDate.set(Calendar.MINUTE, 0);
        currentDate.set(Calendar.SECOND, 0);
        currentDate.set(Calendar.MILLISECOND, 0);
        currentDate.set(Calendar.DAY_OF_MONTH, 1);
        Date date=currentDate.getTime();
        return date.getTime();
    }
    /**
     * 功能：获取本年的开始时间
     */
    public static long endOfTheYear(int year) {
        Calendar cal = Calendar.getInstance();
        cal.set(Calendar.YEAR, year);
        cal.set(Calendar.MONTH,11);
        cal.set(Calendar.DAY_OF_MONTH, 31);
        cal.set(Calendar.HOUR_OF_DAY, 23);
        cal.set(Calendar.MINUTE, 59);
        cal.set(Calendar.SECOND, 59);
        cal.set(Calendar.MILLISECOND, 999);
        Date date=cal.getTime();
        return date.getTime();
    }

	public static void main(String[] args) throws Exception {
		String num1 = "2016-03-02 00:34:00";
		String num2 = "2016-03-02 10:34:00";
		System.out.println(DateUtil.TimeDiff(new Date().toLocaleString(),new Date().toLocaleString()));

        System.out.println("startOfTodDay = " + startOfTodDay());
        System.out.println("endOfTodDay = " + endOfTodDay());
	}
}
