package com.bcxin.survey.startup;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;
import org.springframework.web.context.ServletContextAware;

import javax.servlet.ServletContext;


/**
 * 启动类
 * @author Ethan_Huang
 */
@Service("recruitingStartup")
public class Startup implements InitializingBean, DisposableBean, ServletContextAware, ApplicationContextAware {

	
	@Autowired
	public InitService initService;

	@Override
	public void setServletContext(ServletContext context) {
		InitService.context = context;
	}

	@Override
	public void setApplicationContext(ApplicationContext cxt) throws BeansException {
		InitService.springContext = cxt;
	}

	@Override
	public void destroy() throws Exception {
		
	}

	@Override
	public void afterPropertiesSet() {
		try {
			initService.initConfigData();
		} catch(Exception e) {
		}
	}

}
