package com.bcxin.survey.service.wechat;

import com.bcxin.survey.utils.GlobalResources;
import com.bcxin.survey.utils.StringUtil;
import com.bcxin.survey.wechat.response.Article;
import com.bcxin.survey.wechat.response.NewsMessage;
import com.bcxin.survey.wechat.response.TextMessage;
import com.bcxin.survey.wechat.utils.AuthProcess;
import com.bcxin.survey.wechat.utils.MessageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;


/**
 * 核心服务类
 * 
 * @author 百川信
 * @date 2014-11-24
 */
@Component
public class WechatService {
			
	final static Logger logger = LoggerFactory.getLogger(WechatService.class);
	
	/**
	 * 处理微信发来的请求
	 * 换行符仍然是"\n"
	 * @param request
	 * @return
	 */
	public static String processRequest(HttpServletRequest request) {
		String respMessage = null;
		//加密消息处理
		String encrypt_type =request.getParameter("encrypt_type");
		try {
			// 默认返回的文本消息内容
			String respContent = "请求处理异常，请稍候尝试！";

			// xml请求解析
			Map<String, String> requestMap = null;
			
			if (StringUtil.isEmpty(encrypt_type) || encrypt_type.equals("raw")) { //不用加密
				// 正常的微信处理流程
				requestMap = MessageUtil.parseXml(request);
			} else { //需走加解密流程
				String reqXml = MessageUtil.parseString(request);
				// 解密请求消息体
				String xml = AuthProcess.decryptMsg(request, reqXml);
				requestMap = MessageUtil.parseXml(xml);
			}

			// 发送方帐号（open_id）
			String fromUserName = requestMap.get("FromUserName");
			// 公众帐号
			String toUserName = requestMap.get("ToUserName");
			// 消息类型
			String msgType = requestMap.get("MsgType");

			// 回复文本消息
			TextMessage textMessage = new TextMessage();
			textMessage.setToUserName(fromUserName);
			textMessage.setFromUserName(toUserName);
			//两种获取整形时间的方法。 获取到的结果表示当时时间距离1970年1月1日0时0分0秒0毫秒的毫秒数。公众平台api中消息创建时间CreateTime，它表示1970年1月1日0时0分0秒至消息创建时所间隔的秒数，注意是间隔的秒数，不是毫秒数！
			//long longTime1 = System.currentTimeMillis();  
		    //long longTime2 = new java.util.Date().getTime();  
			textMessage.setCreateTime(System.currentTimeMillis());
			textMessage.setMsgType(MessageUtil.RESP_MESSAGE_TYPE_TEXT);
			textMessage.setFuncFlag(0);

			List<Article> articleList = new ArrayList<Article>();
            // 创建图文消息  
            NewsMessage newsMessage = new NewsMessage();  
            newsMessage.setToUserName(fromUserName);  
            newsMessage.setFromUserName(toUserName);  
            newsMessage.setCreateTime(System.currentTimeMillis());
            newsMessage.setMsgType(MessageUtil.RESP_MESSAGE_TYPE_NEWS);  
            newsMessage.setFuncFlag(0);  
            
			// 文本消息
			if (msgType.equals(MessageUtil.REQ_MESSAGE_TYPE_TEXT)) {
//				 // 文本消息内容  
			    String content = requestMap.get("Content"); 
			    //respContent = surveyTaskService.ManageTaskByOpenIdAndTaskCode(fromUserName, content);
			    if(StringUtil.isEmpty(respContent)) {
					respContent = "您发送的是文本消息！\n谢谢！您发送的内容为：" + content;
				}
			  
			}    
			// 事件推送
			else if (msgType.equals(MessageUtil.REQ_MESSAGE_TYPE_EVENT)) {
				// 事件类型
				String eventType = requestMap.get("Event");
				// 订阅
				if (eventType.equals(MessageUtil.EVENT_TYPE_SUBSCRIBE)) {
					/*Article article = new Article();  
                    article.setTitle("关注身份验证");  
                    article.setDescription("请点击图文进行身份验证以成功关注'PSS业务平台'");  
                    article.setPicUrl("http://" + GlobalResources.DOMAINNAME + "/resources/risk/images/public/shenfenyanzheng.png");  
                    article.setUrl("https://open.weixin.qq.com/connect/oauth2/authorize?appid=" + GlobalResources.APPID + "&redirect_uri=http://" + GlobalResources.DOMAINNAME + "/wechat/user/boundUser/init?weChat=1&response_type=code&scope=snsapi_userinfo&state=1#wechat_redirect");
            		
                    articleList.add(article);
	                newsMessage.setArticles(articleList);  
	                respMessage = MessageUtil.newsMessageToXml(newsMessage);*/

//					respContent = "嗨~很高兴见到您！\r\n\r\n每次相遇都是久别的重逢…\r\n\r\n我会带给您新惊喜\r\n\r\n不止功能体验\r\n\r\n不止好礼相赠\r\n\r\n希望我的出现\r\n\r\n能让您的生活有一点点不一样";
					respContent = "欢迎使用pss业务平台";
				}
				// 取消订阅
				else if (eventType.equals(MessageUtil.EVENT_TYPE_UNSUBSCRIBE)) {
					// 取消订阅后用户再收不到公众号发送的消息，因此不需要回复消息
					logger.info("微信号：" + fromUserName + " 取消关注");
				}
				// 自定义菜单点击事件
				else if (eventType.equals(MessageUtil.EVENT_TYPE_CLICK)) {
					// 事件KEY值，与创建自定义菜单时指定的KEY值对应  
                    String eventKey = requestMap.get("EventKey");  
                    
                    if (eventKey.equals("11")) {  
                        respContent = "资料修改菜单项被点击！";  
                    } else if (eventKey.equals("12")) {  
                        respContent = "燃气交费菜单项被点击！"; 
                        Article article = new Article();  
                        article.setTitle("燃气交费");  
                        article.setDescription("百川信燃气平台燃气交费");  
                        article.setPicUrl("http://" + GlobalResources.DOMAINNAME + "/naturalGas/payment.jpg");  
                        article.setUrl("http://" + GlobalResources.DOMAINNAME + "/naturalGas/payment/payment/init?weChat=1&userName=" + fromUserName);  
                        articleList.add(article);  
                    } else if (eventKey.equals("13")) {  
                        respContent = "IC卡充值菜单项被点击！";  
                        Article article = new Article();  
                        article.setTitle("IC卡充值");  
                        article.setDescription("百川信燃气平台IC卡充值");  
                        article.setPicUrl("http://www.bcxin.com.cn/naturalGas/payment.jpg");  
                        article.setUrl("http://" + GlobalResources.DOMAINNAME + "/naturalGas/payment/icRecharge/init?weChat=1&userName=" + fromUserName);  
                        articleList.add(article); 
                    } else if (eventKey.equals("14")) {  
                        respContent = "历史上的今天菜单项被点击！";  
                    } else if (eventKey.equals("21")) {  
                        respContent = "设备报修菜单项被点击！";  
                    } else if (eventKey.equals("22")) {  
                        respContent = "报装申请菜单项被点击！";  
                    } else if (eventKey.equals("23")) {  
                        respContent = "美女电台菜单项被点击！";  
                    } else if (eventKey.equals("24")) {  
                        respContent = "人脸识别菜单项被点击！";  
                    } else if (eventKey.equals("25")) {  
                        respContent = "聊天唠嗑菜单项被点击！";  
                    } else if (eventKey.equals("31")) {  
                        respContent = "敬请期待！";
                        
//                        Article article = new Article();  
//                        article.setTitle("燃气交费");  
//                        article.setDescription("百川信燃气平台燃气交费");  
//                        article.setPicUrl("http://" + domainName + "/naturalGas/payment.jpg");  
//                        article.setUrl("http://" + domainName + "/naturalGas/payment/payment/init?weChat=1&userName=" + fromUserName);  
//                        articleList.add(article);  
                        
                    } else if (eventKey.equals("32")) {  
                        respContent = "敬请期待！";
                        
//                        Article article = new Article();  
//                        article.setTitle("IC卡充值");  
//                        article.setDescription("百川信燃气平台IC卡充值");  
//                        article.setPicUrl("http://www.bcxin.com.cn/naturalGas/payment.jpg");  
//                        article.setUrl("http://baichuanxin.oicp.net/naturalGas/payment/icRecharge/init?WeChat=1&userName=" + fromUserName);  
//                        articleList.add(article); 
                    } else if (eventKey.equals("33")) {  
                        respContent = "敬请期待！";  
                    }  
				}
			}
			if (articleList != null && articleList.size() > 0) {
            	// 设置图文消息个数  
                newsMessage.setArticleCount(articleList.size());  
                // 设置图文消息包含的图文集合  
                newsMessage.setArticles(articleList);  
                // 将图文消息对象转换成xml字符串  
                respMessage = MessageUtil.newsMessageToXml(newsMessage);
            }

			textMessage.setContent(respContent);
			if (respMessage == null) {
				respMessage = MessageUtil.textMessageToXml(textMessage);
			}
		} catch (Exception e) {
			e.printStackTrace();
			logger.error("微信平台请求异常！", e.toString());
		}

		if (StringUtil.isEmpty(encrypt_type) || encrypt_type.equals("raw")) { //不用加密
			return respMessage;
		} else {
			return AuthProcess.encryptMsg(request, respMessage);
		}
	}
	
}