package com.bcxin.survey.service.wechat;

import com.bcxin.survey.dao.report.BaseDao;
import com.bcxin.survey.dao.report.CMSDao;
import com.bcxin.survey.domain.survey.Survey_Info;
import com.bcxin.survey.dto.ActivityCooperDTO;
import com.bcxin.survey.dto.SurveyInfoDto;
import com.bcxin.survey.enums.report.QuestionType;
import com.bcxin.survey.enums.report.SurveyStep;
import com.bcxin.survey.utils.StringUtil;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Service
@Transactional
public class SurveyInfoServiceImpl implements SurveyInfoService {

	@Autowired
	private BaseDao baseDao;
	
	@Autowired
	private CMSDao cmsDao;
	
	@Autowired
	private SurveyTagService surveyTagService;

	@Override
	public boolean saveOrUpdate(Survey_Info surveyInfo){
		boolean flag = true;
		try {
			surveyInfo.setUpdateOn(new Date());
			baseDao.saveOrUpdate(surveyInfo);		
		}catch(Exception e) {
			flag = false;
		}
		return flag;
	}

	@Override
	public boolean delete(Survey_Info surveyInfo){
		boolean flag = true;
		try {
			baseDao.delete(surveyInfo);		
		}catch(Exception e) {
			flag = false;
		}
		return flag;
	}

	@Override
	public Survey_Info findSurveyInfoByOid(long oid){
		return baseDao.get(Survey_Info.class, oid);
	}


	@Override
	public List<Survey_Info> findSurveyInfoListByQuestionnaireId(long questionnaireId) {
		List<Criterion> criterionList = new ArrayList<Criterion>();
		criterionList.add(Restrictions.eq("questionnaire.oid", questionnaireId));
		List<Order> orders = new ArrayList<Order>();
		orders.add(Order.asc("sort"));
		orders.add(Order.asc("oid"));
		return baseDao.findByCriterion(Survey_Info.class,criterionList,orders);
	}

	@Override
	public List<SurveyInfoDto> findSurveyInfoDtoListByQuestionnaireId(long questionnaireId) {

		StringBuffer sql = new StringBuffer("select CONCAT(a.oid) AS oid,b.question,a.answer " +
				" from RISK_Survey_Info a  " +
				" inner join RISK_SurveyProject b on a.oid=b.oid where 1=1 ");

		sql.append(" and a.questionnaireId="+questionnaireId);
		sql.append(" order by b.sort asc, a.oid asc");
		List<SurveyInfoDto> dtoList = Lists.newArrayList();
		List<Map<String,Object>> list = baseDao.findBySQL(sql.toString(),null);
		list.forEach(result->{
			Map<String,Object> map = (Map<String,Object>)result;
			SurveyInfoDto dto = new SurveyInfoDto(map);
			dtoList.add(dto);
		});
		return dtoList;
	}


	@Override
	public List<Survey_Info> findSurveyInfoListByStep(SurveyStep surveyStep) {
		List<Criterion> criterionList = new ArrayList<Criterion>();
		criterionList.add(Restrictions.eq("surveyStep", surveyStep));
		return baseDao.findByCriterion(Survey_Info.class,criterionList);
	}


	@Override
	public List<Survey_Info> findSurveyInfoListByTag(String tag) {
		List<Criterion> criterionList = new ArrayList<Criterion>();
		criterionList.add(Restrictions.like("label", "%"+tag+"%"));
		criterionList.add(Restrictions.like("fixed", false));
		return baseDao.findByCriterion(Survey_Info.class,criterionList);
	}

	@Override
	public List<Survey_Info> getSurveyInfoFormCMSForFix(SurveyStep surveyStep,String activityType,String addressType){
		List<Survey_Info> infos= cmsDao.getSurvey_InfoFromCMSForFix(surveyStep,activityType,addressType);
		return infos;
	}


	@Override
	public Survey_Info findSurveyInfoByaid(String aid, long questionnaireId) {
		List<Criterion> criterionList = new ArrayList<Criterion>();
		criterionList.add(Restrictions.eq("aid", aid));
		criterionList.add(Restrictions.eq("questionnaire.oid", questionnaireId));
		List<Survey_Info> infos = baseDao.findByCriterion(Survey_Info.class,criterionList);
		if(infos.size() >0) {
			return infos.get(0);
		}
		return null;
	}



	@Override
	public Survey_Info findSurveyInfoByaidAndQuestionType(String aid, long questionnaireId,QuestionType questionType) {
		List<Criterion> criterionList = new ArrayList<Criterion>();
		criterionList.add(Restrictions.eq("aid", aid));
		criterionList.add(Restrictions.eq("questionnaire.oid", questionnaireId));
		if(questionType != null) {
			criterionList.add(Restrictions.eq("questionType", questionType));
		}
		List<Survey_Info> infos = baseDao.findByCriterion(Survey_Info.class,criterionList);
		if(infos.size() >0) {
			return infos.get(0);
		}
		return null;
	}
	
	@Override
	public List<Survey_Info> findSurveyInfoFromCMSByTags(String tags) {
		return cmsDao.findSurveyInfoByTags(tags);
	}

	@Override
	public Survey_Info findSurveyInfoByaidFormCMS(String aid) {
		return cmsDao.findSurveyInfoByAid(aid);
	}

	
	@SuppressWarnings("unchecked")
	@Override
	public List<Survey_Info> findNextSurveyInfoListByQuestionnaireId(long questionnaireId) {
		List<Criterion> criterionList = new ArrayList<Criterion>();
		criterionList.add(Restrictions.eq("questionnaire.oid", questionnaireId));
		criterionList.add(Restrictions.eq("nextSurvey", true));
		return baseDao.findByCriterion(Survey_Info.class,criterionList);
	}

	@SuppressWarnings("unchecked")
	@Override
	public Survey_Info findSurveyInfoByquestionnaireIdAndQuestion(long questionnaireId, String question) {
		List<Criterion> criterionList = new ArrayList<Criterion>();
		criterionList.add(Restrictions.eq("questionnaire.oid", questionnaireId));
		criterionList.add(Restrictions.eq("questionType", QuestionType.SUPPLEMENT));
		if(StringUtil.isNotEmpty(question)) {
			criterionList.add(Restrictions.eq("question", question));
		}
		List<Survey_Info> survey_Infos = baseDao.findByCriterion(Survey_Info.class,criterionList);
		if(survey_Infos != null && survey_Infos.size() > 0) {
			return survey_Infos.get(0);
		}
		return null;
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<Survey_Info> findRectificationSurveyInfosByQuestionnaireId(long questionnaireId) {
		List<Criterion> criterionList = new ArrayList<Criterion>();
		criterionList.add(Restrictions.eq("questionnaire.oid", questionnaireId));
		criterionList.add(Restrictions.neOrIsNotNull("assessment", ""));
		List<Survey_Info> survey_Infos = baseDao.findByCriterion(Survey_Info.class,criterionList);
		return survey_Infos;
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<Survey_Info> findSurveyInfosByQuestionTypeAndQuestionnaireId(QuestionType questionType,long questionnaireId) {
		List<Criterion> criterionList = new ArrayList<Criterion>();
		criterionList.add(Restrictions.eq("questionnaire.oid", questionnaireId));
		if(questionType != null) {
			criterionList.add(Restrictions.eq("questionType", questionType));
		}
			
		List<Order> orders = new ArrayList<Order>();
//		orders.add(Order.asc("questionType"));
		orders.add(Order.asc("sort"));
		return baseDao.findByCriterion(Survey_Info.class,criterionList,orders);
	}
}
