package com.bcxin.survey.service.wechat;

import com.bcxin.survey.domain.activity.Activity;
import com.bcxin.survey.domain.data.MaterialTask;
import com.bcxin.survey.domain.security.User;
import com.bcxin.survey.domain.survey.SurveyPlan;
import com.bcxin.survey.domain.survey.SurveyTask;
import com.bcxin.survey.domain.survey.Survey_FeedBack;
import com.bcxin.survey.domain.survey.Survey_Info;
import com.bcxin.survey.enums.report.SurveyStep;
import net.sf.json.JSONObject;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

public interface SurveyFeedBackService {

	boolean saveOrUpdate(Survey_FeedBack feedBack);

	boolean delete(Survey_FeedBack feedBack);

	Survey_FeedBack findSurveyFeedBackByOid(long oid);

	List<Survey_FeedBack> findSurvey_FeedBackByTaskId(long taskId);

	List<Survey_FeedBack> findSurvey_FeedBackListBySurveyTaskId(long taskId);
	
	Survey_FeedBack findSurvey_FeedBackListBySurveyTaskIdAndStep(long taskId,SurveyStep step);

	Survey_FeedBack findSurveyFeedBackByTaskAndStep(SurveyTask task, SurveyStep surveyStep);

	JSONObject createQuestion(User user, long questionnaireId, HttpServletRequest request);

	JSONObject finishSurvey(HttpServletRequest request);

	JSONObject finishSurveyNew(HttpServletRequest request);

	void checkFeedBackStatusByFeedBackId(long feedBackId);
	/**
	 * 上传签名图片
	 * @param signImgPath
	 * @param request
	 * @return
	 */
	String generateImage(String signImgPath, String feedBackPath, HttpServletRequest request);
	String generateImageFile(MultipartFile multipartFile, String feedBackPath, HttpServletRequest request);

	boolean uploadSurveyImg(String mediaId, Survey_Info surveyInfo, HttpServletRequest request);

	void checkFeedBackStatusByQuestionnaireId(long questionnaireId);

	void syncSurvey(Activity activity, SurveyPlan surveyPlan, MaterialTask materialTask);
}