package com.bcxin.survey.service.wechat;

import com.bcxin.survey.dao.report.BaseDao;
import com.bcxin.survey.domain.activity.Activity;
import com.bcxin.survey.domain.activity.Message;
import com.bcxin.survey.domain.dynamic.DynamicTemplateConst;
import com.bcxin.survey.domain.report.Task;
import com.bcxin.survey.domain.security.User;
import com.bcxin.survey.domain.survey.SurveyAssist;
import com.bcxin.survey.domain.survey.SurveyTask;
import com.bcxin.survey.enums.dynamic.DynamicPermissionEnum;
import com.bcxin.survey.enums.report.*;
import com.bcxin.survey.service.CommonService;
import com.bcxin.survey.service.NotifyService;
import com.bcxin.survey.service.UserService;
import com.bcxin.survey.utils.Const;
import com.bcxin.survey.utils.DictConst;
import com.bcxin.survey.utils.DynamicUtil;
import com.bcxin.survey.utils.SurveyManagerUtil;
import com.bcxin.survey.utils.sms.SMSUtil;
import com.bcxin.survey.vo.EmailModel;
import com.bcxin.survey.vo.MessageModel;
import net.sf.json.JSONObject;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service
@Transactional
public class SurveyAssistServiceImpl implements SurveyAssistService{
	
	@Autowired
	private BaseDao baseDao;
	
	@Autowired
	private UserService userService;
	
	@Autowired 
	private SurveyTaskService surveyTaskService;

	@Autowired
	private NotifyService notifyService;

	@Autowired
	private SurveyManagerUtil surveyManagerUtil;
	@Autowired
	private DynamicUtil dynamicUtil;
	@Autowired
	private CommonService commonService;


	@Override
	public boolean saveOrUpdate(SurveyAssist surveyAssist){
		boolean flag = true;
		try {
			surveyAssist.setUpdateOn(new Date());
			baseDao.saveOrUpdate(surveyAssist);
		}catch(Exception e) {
			flag = false;
		}
		return flag;
	}

	@Override
	public boolean delete(SurveyAssist surveyAssist) {
		boolean flag = true;
		try {
			baseDao.delete(surveyAssist);
		}catch(Exception e) {
			flag = false;
		}
		return flag;
	}

	@Override
	public SurveyAssist findSurveyAssistByOid(long oid){
		return baseDao.get(SurveyAssist.class, oid);
	}

	@SuppressWarnings("unchecked")
	@Override
	public SurveyAssist findSurveyAssistByTaskAndStepAndStatus(SurveyTask task,SurveyStep surveyStep, AssignStatus assignStatus,AssignType assignType){
		List<Criterion> criterions = new ArrayList<Criterion>();
		criterions.add(Restrictions.eq("surveyTask", task));
		if(surveyStep != null) {
			criterions.add(Restrictions.eq("surveyStep", surveyStep));
		}
		criterions.add(Restrictions.eq("assignStatus", assignStatus));
		criterions.add(Restrictions.eq("assignType", assignType));
		List<SurveyAssist> assists = baseDao.findByCriterion(SurveyAssist.class, criterions);
		if(assists != null && assists.size() > 0) {
			return assists.get(0);
		}
		return null;
	}

	@Override
	public JSONObject transferTask(SurveyAssist surveyAssist) {
		String message = "";
		String status = "300";
		JSONObject json = new JSONObject();
		SurveyAssist oldAssist = findSurveyAssistByTaskAndStepAndStatus(surveyAssist.getSurveyTask(),surveyAssist.getSurveyStep(),AssignStatus.NON,AssignType.TRANSFERTASK);
		if(oldAssist != null){
			message ="您已提交过任务转交的申请，请耐心等待审核结果！";
		}else{
			surveyAssist.setCreateOn(new Date());
			surveyAssist.setAssignStatus(AssignStatus.NON);
			surveyAssist.setAssignType(AssignType.TRANSFERTASK);
			if(saveOrUpdate(surveyAssist)){
				SurveyTask surveyTask = surveyTaskService.findSurveyTaskByOid(surveyAssist.getSurveyTask().getOid());
				surveyTask.setSurveyTaskStatus(SurveyTaskStatus.TRANSFERAUDIT);
				surveyTaskService.saveOrUpdate(surveyTask);
				status = "200";
				message ="任务转交申请已提交成功，请等待审批结果！";

				//发送通知给勘查项目经理
				if (surveyTask != null) {

					Activity activity = surveyManagerUtil.selectActivity(surveyTask);
					Task task = surveyManagerUtil.selectTaskBySurveyTask(surveyTask);
					User user = userService.getCurrentUser();

					// 保存到动态看板
					dynamicUtil.saveTKData(user, DynamicTemplateConst.DYNAMIC_TEMP_KANCHA_400005, task.getOid(), DynamicPermissionEnum.DYNAMIC_FENGPING);


					//查询勘查项目经理
					List<User> userList = userService.findUserListByOrgIdAndUserType(user.getOrg().getOid(), DictConst.USERTYPE_DSFFWJGYH_TKXMJL);
					for (User pm : userList) {
						//手机短信通知
						String content = user.getRealName() + "申请转交勘查任务" + activity.getName() + "，" +
								"请登录" + SMSUtil.platFormName() + "查看申请原因，及时处理申请。";
						notifyService.sendHuaWeiSMS(pm.getPhone(),content, Const.ENVI_TK, DictConst.SMSCODE_B07,new String[]{user.getRealName(),activity.getName(),SMSUtil.platFormName()});
						//邮件通知
						EmailModel model = new EmailModel();
						model.setSubject(user.getRealName() + "申请转交勘查任务");
						model.setEmailType(EmailMsgType.SURVEYTASK);
						model.setContent(user.getRealName() + "申请转交勘查任务" + activity.getName() + "，申请原因：" + surveyAssist.getReason() + "，请及时处理。【" + SMSUtil.platFormName() + "】");
						model.setTo(pm.getEmail());
						notifyService.sendEmail(model);
					}

					// 发送消息
					if (user != null && activity != null) {
						Message msg = new Message();
						msg.setContent(user.getRealName() + "申请转交勘查任务" + activity.getName() + "，申请原因：" + surveyAssist.getReason() + "，请及时处理。");
						msg.setTitle(user.getRealName() + "申请转交勘查任务");
						msg.setKeyword("立即处理");
						msg.setUrl("/survey/assist/assistPageList");
						surveyManagerUtil.saveMessage(surveyTask, msg);
					}
				}
			} else {
				message = "申请失败,请重试！";
			}
		}
		json.put("status", status);
		json.put("message", message);
		return json;
	}

	@Override
	public JSONObject applyExpert(SurveyAssist surveyAssist) {
		String message = "";
		String status = "300";
		JSONObject json = new JSONObject();

		SurveyAssist oldAssist = findSurveyAssistByTaskAndStepAndStatus(surveyAssist.getSurveyTask(),surveyAssist.getSurveyStep(),AssignStatus.NON,AssignType.APPLYEXPERT);
		if(oldAssist != null){
			message ="您已提交过专家协助的申请，请耐心等待审核结果！";
		}else{
			surveyAssist.setCreateOn(new Date());
			surveyAssist.setAccepter(null);
			surveyAssist.setAssignStatus(AssignStatus.NON);
			surveyAssist.setAssignType(AssignType.APPLYEXPERT);
			if(saveOrUpdate(surveyAssist)){
				status = "200";
				message ="专家协助的申请已提交成功，请耐心等待审批结果！";

				//发送通知给勘查项目经理和勘查区域经理
				SurveyTask surveyTask = surveyAssist.getSurveyTask();
				if (surveyTask != null) {

					Activity activity = surveyManagerUtil.selectActivity(surveyTask);
					Long orgId=commonService.getFengPingOrg(activity);

					Task task = surveyManagerUtil.selectTaskBySurveyTask(surveyTask);
					User user = userService.getCurrentUser();
					// 保存动态看板
					dynamicUtil.saveTKData(user, DynamicTemplateConst.DYNAMIC_TEMP_KANCHA_400006, task.getOid(), DynamicPermissionEnum.DYNAMIC_FENGPING);

					//查询勘查项目经理
					List<User> userList = userService.findUserListByOrgIdAndUserType(orgId, DictConst.USERTYPE_DSFFWJGYH_TKXMJL);
					for (User pm : userList) {
						//手机短信通知
						String content = user.getRealName() + "申请专家协助处理勘查任务" + activity.getName() + "，" +
								"请登录" + SMSUtil.platFormName() + "查看申请原因，及时处理申请。";
						notifyService.sendHuaWeiSMS(pm.getPhone(),content, Const.ENVI_TK, DictConst.SMSCODE_B06,new String[]{user.getRealName(),activity.getName(),SMSUtil.platFormName()});

						//邮件通知
						EmailModel model = new EmailModel();
						model.setSubject(user.getRealName() + "申请专家协助");
						model.setEmailType(EmailMsgType.SURVEYTASK);
						model.setContent(user.getRealName() + "申请专家协助处理勘查任务" + activity.getName() + "，" +
								"申请原因：" + surveyAssist.getReason() + "，请及时处理。【" + SMSUtil.platFormName() + "】");
						model.setTo(pm.getEmail());
						notifyService.sendEmail(model);
					}

					if (user != null && task != null) {
						Message msg = new Message();
						msg.setContent(user.getRealName() + "申请专家协助处理勘查任务" + activity.getName() + "，申请原因：" + surveyAssist.getReason() + "，请及时处理。");
						msg.setTitle(user.getRealName() + "申请专家协助");
						msg.setKeyword("立即查看");
						msg.setUrl("/survey/assist/assistPageList");
						surveyManagerUtil.saveMessage(surveyTask, msg);
					}
				}
			} else {
				message = "申请失败,请重试！";
			}
		}
		json.put("status", status);
		json.put("message", message);
		return json;
	}
		
}
