package com.bcxin.survey.service.manage;

import com.bcxin.survey.dao.report.TaskDao;
import com.bcxin.survey.domain.activity.Activity;
import com.bcxin.survey.domain.report.Task;
import com.bcxin.survey.domain.security.User;
import com.bcxin.survey.domain.survey.SurveyTask;
import com.bcxin.survey.dto.TaskDetailVo;
import com.bcxin.survey.dto.TaskSearchDto;
import com.bcxin.survey.enums.report.AcceptStatus;
import com.bcxin.survey.enums.report.SurveyTaskStatus;
import com.bcxin.survey.enums.report.TaskStatus;
import com.bcxin.survey.service.NotifyService;
import com.bcxin.survey.service.UserService;
import com.bcxin.survey.service.wechat.SurveyTaskService;
import com.bcxin.survey.utils.*;
import com.bcxin.survey.vo.DwzPage;
import org.hibernate.Hibernate;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Service
@Transactional
public class TaskManageServiceImpl implements TaskManageService {

	@Autowired
	private TaskDao taskDao;

	@Autowired
	private UserService userService;

	@Autowired
	private NotifyService notifyService;

	@Autowired
	private SurveyTaskService surveyTaskService;

	@Override
	public boolean saveOrUpdate(Task task) {
		boolean flag = true;
		try {
			if(task != null){
				task.setUpdateOn(new Date());
				taskDao.update(task);
			}
		} catch(Exception e) {
			flag = false;
		}
		return flag;
	}

	@Override
	public List<Task> findAllTaskListForSurvey(){
		List<Criterion> criterionList = new ArrayList<Criterion>();
		criterionList.add(Restrictions.eq("taskType", "2"));
		return taskDao.findByCriterion(Task.class, criterionList);
	}

	public List<Task> findTaskListByBoxForPage(Task task , DwzPage page){
		List<Criterion> criterionList = new ArrayList<Criterion>();
		if (task !=null) {
			if (StringUtil.isNotEmpty(task.getName())) {
				criterionList.add(Restrictions.like("name", "%"+task.getName()+"%"));
			}
			if (task.getAcceptStatus()!=null) {
				criterionList.add(Restrictions.eq("acceptStatus", task.getAcceptStatus()));
			}
		}
		criterionList.add(Restrictions.eq("isNeedAssign", true));
		List<Task> tasks = taskDao.findByCriterionForPage(Task.class, criterionList, page);
		for (Task eachTask : tasks) {
			Hibernate.initialize(eachTask.getActivity());
			Hibernate.initialize(eachTask.getAssgin());
		}
		return tasks;
	}

	@Override
	public boolean acceptTask(Task task){
		task.setAcceptDate(new Date());
//		task.setAcceptStatus(AcceptStatus.YES);
//		task.setTaskStatus(TaskStatus.CONTINUE);
		task.setAcceptStatus(AcceptStatus.YES.getKey());
		task.setTaskStatus(TaskStatus.ACCEPT.getKey());
		return saveOrUpdate(task);
	}

	@SuppressWarnings("unchecked")
	@Override
	public Map<String, String> distributeTask(String oid,String assgin) throws Exception {
		Task task = taskDao.findTaskByOid(Long.parseLong(oid));
		User assginU = userService.findUserByOid(Long.parseLong(assgin));
		boolean result = false;

		try {
			Activity activity = task.getActivity();
			Date endTime = DateUtil.convertStringToDate(activity.getStartDate());
			if(endTime.getTime() < System.currentTimeMillis()){
				task.setTaskStatus(TaskStatus.CLOSE.getKey());
				saveOrUpdate(task);
				return DWZUtil.returnFailedJson("已过活动时间！无须再分配", "taskList","closeCurrent", "");
			}
		} catch (Exception e) {
			e.printStackTrace();
		}

		if(task.getAcceptStatus().equals(AcceptStatus.YES)) {
			return DWZUtil.returnFailedJson("任务已经接受！无须再分配", "taskList", "closeCurrent", "");
		}
		task.setAcceptDate(new Date());
		task.setAssgin(assginU);
//		task.setTaskStatus(TaskStatus.ASSIGNED);
		task.setTaskStatus(TaskStatus.UN_ACCEPT.getKey());
		surveyTaskService.distributeTask(task);
		result = saveOrUpdate(task);
		if(result){
			return DWZUtil.returnSuccessJson(Tips_CN.OP_SUCCEED, "taskList","closeCurrent", "task/taskList/init");
		}
		else {
			return DWZUtil.returnFailedJson(Tips_CN.OP_FAILURE, "taskList", "closeCurrent", "");
		}
	}

	/**
	 * 拒绝任务
	 */
	@Override
	public boolean refuseTask(Task task) {
		task.setAssgin(null);
//		task.setTaskStatus(TaskStatus.NON);
		task.setTaskStatus(TaskStatus.REFUSE.getKey());
		return saveOrUpdate(task);
	}

	public String getTaskButton(String url,String btName){
		return "<a class='btn' target='_blank' href='"+url+"'>"+btName+"</a>";
	}

	@Override
	public void sendUnReceiveTaskMsgForPM(){
		List<User> users = userService.findUserListByOrgIdAndUserType(null,DictConst.USERTYPE_DSFFWJGYH_TKXMJL);
		if(users != null && users.size() > 0) {
			users.forEach(user -> {
				if(user.getOrg() != null) {
					List<TaskDetailVo> taskList = findTaskListByOvertime3Hour(user.getOrg().getOid());
					if (taskList != null && taskList.size() > 0) {
						EmailUtil se = new EmailUtil();
						String title = "勘查任务超过三个小时未接受(测试)";
						String context = "Dear 项目经理：<br>&nbsp;&nbsp;&nbsp;&nbsp;以下勘查任务超过三个小时未接受，请及时重新分配。<br><br>";
						context = context + "<table style='font-family: verdana,arial,sans-serif;font-size:12px;color:#333333;border-width: 1px;border-color: #666666;border-collapse: collapse'>";
						context = context + "<tr><th style='border-width: 1px;padding: 8px;text-align:center;border-style: solid;border-color: #666666;background-color: #dedede;'>勘查人员</th>"
								+ "<th style='border-width: 1px;padding: 8px;text-align:center;border-style: solid;border-color: #666666;background-color: #dedede;'>活动名称</th></tr>";

						for (TaskDetailVo taskDetail : taskList) {
							String assginName = taskDetail.getAssgin();
							String taskName = taskDetail.getName();
							context = context + "<tr><td style='border-width: 1px;padding: 8px;text-align:center;border-style: solid;border-color: #666666;background-color: #ffffff;'>" + assginName + "</td>"
									+ "<td style='border-width: 1px;padding: 8px;border-style: solid;border-color: #666666;background-color: #ffffff;'>" + taskName + "</td></tr>";
							SurveyTask surveyTask = surveyTaskService.findSurveyTaskByTaskId(taskDetail.getOid());
							if (surveyTask != null) {
								surveyTask.setSurveyTaskStatus(SurveyTaskStatus.OVERTIME);
								surveyTaskService.saveOrUpdate(surveyTask);
							}
							Task dbTask = taskDao.findTaskByOid(taskDetail.getOid());
							dbTask.setAssgin(null);
//							dbTask.setTaskStatus(TaskStatus.NON);
							// 超时未接受，默认拒绝
							dbTask.setTaskStatus(TaskStatus.REFUSE.getKey());
							saveOrUpdate(dbTask);

							if (StringUtil.isNotEmpty(user.getPhone())) {
								notifyService.sendHuaWeiSMS(user.getPhone(),assginName + "未接受“" + taskName + "”活动的勘查任务，请及时重新分配", Const.ENVI_TK, DictConst.SMSCODE_B05,new String[]{assginName,taskName});
							}
						}
						context = context + "</table>";

						if (StringUtil.isNotEmpty(user.getEmail())) {
							se.sendEmail(title, context, user.getEmail(), null);
						}
					}
				}
			});
		}
	}

	private List<TaskDetailVo> findTaskListByOvertime3Hour(Long orgId){
		return taskDao.findTaskListByOvertime3Hour(orgId);
	}

	@Override
	public void endOverTimeTask(){
		List<Criterion> criterionList = new ArrayList<Criterion>();
		criterionList.add(Restrictions.eq("surveyTaskStatus",SurveyTaskStatus.DOING));
		try {
			Date nowTime = DateUtil.convertStringToDate(DateUtil.dateAdd(4, DateUtil.getCurrentDate("yyyy-MM-dd HH:mm:ss"), -3));
			System.out.println(DateUtil.dateAdd(4, DateUtil.getCurrentDate("yyyy-MM-dd HH:mm:ss"), -3));
			criterionList.add(Restrictions.lt("endTime",nowTime));
		} catch (Exception e) {
			e.printStackTrace();
		}
		List<SurveyTask> tasks =  taskDao.findByCriterion(SurveyTask.class, criterionList);
		for (SurveyTask surveyTask : tasks) {
			surveyTask.setSurveyTaskStatus(SurveyTaskStatus.OBSOLETE);
			taskDao.saveOrUpdate(surveyTask);
		}
	}

	@Override
	public void openEndOverTimeTask() {
		String sql = "update risk_surveytask set surveyTaskStatus='DOING' where surveyTaskStatus='OBSOLETE';";
		int count = taskDao.executeUpdate(sql);
		System.out.println("共修改:"+count+"条");
	}


	/**
	 * <b>Function </b>
	 *
	 * @param page
	 * @return
	 * @author LinQingLin
	 * @date 2016年12月22日 下午2:29:29
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public List<Task> findAllSurveyTaskListForPage(DwzPage page) {
		List<Criterion> criterionList = new ArrayList<Criterion>();
		if(StringUtil.isNotEmpty(page.getHtml())){
			criterionList.add(Restrictions.like("name", "%"+page.getHtml()+"%"));
		}
		criterionList.add(Restrictions.eq("taskType", "2"));
		Order order = Order.desc("createOn");
		if(StringUtil.isNotEmpty(page.getOrderField())){
			if(StringUtil.isEmpty(page.getOrderDirection()) || page.getOrderDirection().equals("asc")){
				order = Order.asc(page.getOrderField());
			}else{
				order = Order.desc(page.getOrderField());
			}
		}
		return taskDao.findByCriterionForPage(Task.class, criterionList,page,order);
	}

	@Override
	public List<TaskDetailVo> findSurveyTaskListForPage(TaskSearchDto searchDto, DwzPage page) {
		return taskDao.findSurveyTaskListForPage(searchDto, page);
	}
}
