package com.bcxin.survey.service.manage;

import com.bcxin.survey.dao.report.BaseDao;
import com.bcxin.survey.domain.activity.Activity;
import com.bcxin.survey.domain.activity.ExpertOrderForm;
import com.bcxin.survey.domain.activity.OrderForm;
import com.bcxin.survey.domain.report.Task;
import com.bcxin.survey.domain.security.User;
import com.bcxin.survey.domain.survey.SurveyAssist;
import com.bcxin.survey.domain.survey.SurveyTask;
import com.bcxin.survey.domain.survey.Survey_FeedBack;
import com.bcxin.survey.enums.report.*;
import com.bcxin.survey.service.NotifyService;
import com.bcxin.survey.service.report.ActivityService;
import com.bcxin.survey.service.wechat.SurveyAssistService;
import com.bcxin.survey.service.wechat.SurveyFeedBackService;
import com.bcxin.survey.service.wechat.SurveyTaskService;
import com.bcxin.survey.utils.*;
import com.bcxin.survey.vo.DwzPage;
import com.bcxin.survey.vo.EmailModel;
import com.bcxin.survey.vo.MessageModel;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Service
@Transactional
public class SurveyAssistManageServiceImpl implements SurveyAssistManageService {

	@Autowired
	private BaseDao baseDao;
	
	@Autowired
	private SurveyAssistService surveyAssistService;
	
	@Autowired
	private SurveyFeedBackService surveyFeedBackService;

	@Autowired
	private TaskManageService taskManageService;
	
	@Autowired
	private SurveyTaskService surveyTaskService;
	
	@Autowired
	private NotifyService notifyService;

	@Autowired
	private ActivityService activityService;
	
	@SuppressWarnings("unchecked")
	@Override
	public List<SurveyAssist> findSurveyAssistListForPage(DwzPage page) {
		List<Criterion> criterionList = new ArrayList<Criterion>();
		if(StringUtil.isNotEmpty(page.getHtml())){
			List<SurveyTask> taskList = baseDao.findByCriterion(SurveyTask.class, Restrictions.like("name", "%"+page.getHtml()+"%"));
			if(taskList != null && taskList.size()>0){
				criterionList.add(Restrictions.in("surveyTask", taskList));
			}else{
				criterionList.add(Restrictions.like("reason", "%"+page.getHtml()+"%"));
			}
		}
		
		Order order = Order.desc("createOn");
		if(StringUtil.isNotEmpty(page.getOrderField())){
			if(StringUtil.isEmpty(page.getOrderDirection()) || page.getOrderDirection().equals("asc")){
				order = Order.asc(page.getOrderField());
			}else{
				order = Order.desc(page.getOrderField());
			}
		}
		return baseDao.findByCriterionForPage(SurveyAssist.class, criterionList, page,order);
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<SurveyAssist> findSurveyAssistList(){
		return baseDao.findAll(SurveyAssist.class);
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public List<SurveyAssist> findSurveyAssistListByBox(SurveyAssist surveyAssist, DwzPage page) {
		List<Criterion> criterionList = new ArrayList<Criterion>();
		if(surveyAssist.getAssignType() != null) {
			criterionList.add(Restrictions.like("assignType", surveyAssist.getAssignType()));
		}
		return baseDao.findByCriterionForPage(SurveyAssist.class, criterionList, page, Order.asc("createOn"));
	}

	@SuppressWarnings("unchecked")
	@Override
	public Map<String, String> editExpert(SurveyAssist surveyAssist) {
		SurveyAssist oldAssist = surveyAssistService.findSurveyAssistByOid(surveyAssist.getOid());
		if(!oldAssist.getAssignStatus().equals(AssignStatus.NON)) {
			return DWZUtil.returnFailedJson("该申请已审批", "assistList", "closeCurrent", "");
		}
		Survey_FeedBack surveyFeedBack= surveyFeedBackService.findSurveyFeedBackByTaskAndStep(oldAssist.getSurveyTask(),oldAssist.getSurveyStep());
		oldAssist.setAssignStatus(surveyAssist.getAssignStatus());
		surveyAssistService.saveOrUpdate(oldAssist);
		if(surveyAssist.getAssignStatus().equals(AssignStatus.NOTPASS)){
			String content = "您提交的关于\""+oldAssist.getSurveyTask().getName()+"\"("+oldAssist.getSurveyStep().getName()+")的专家申请没通过审核，请联系项目经理确认！";
			notifyService.sendHuaWeiSMS(oldAssist.getUser().getPhone(),content, Const.ENVI_TK, DictConst.SMSCODE_B01,new String[]{oldAssist.getSurveyTask().getName(),oldAssist.getSurveyStep().getName()});
			
			//邮件通知
			EmailModel model = new EmailModel();
			model.setSubject("专家申请");
			model.setEmailType(EmailMsgType.SURVEYTASK);
			model.setContent(content);
			model.setTo(oldAssist.getUser().getEmail());
			notifyService.sendEmail(model);
			
			return DWZUtil.returnSuccessJson("审批完成", "assistList","closeCurrent", "survey/assistList/init");
		}
		if(surveyFeedBack == null){
			oldAssist.setAssignStatus(AssignStatus.CLOSE);
			surveyAssistService.saveOrUpdate(oldAssist);
			String content = "您提交的关于\""+oldAssist.getSurveyTask().getName()+"\"("+oldAssist.getSurveyStep().getName()+")的专家申请没通过审核，请联系项目经理确认！";
			notifyService.sendHuaWeiSMS(oldAssist.getUser().getPhone(),content, Const.ENVI_TK, DictConst.SMSCODE_B01,new String[]{oldAssist.getSurveyTask().getName(),oldAssist.getSurveyStep().getName()});
			
			//邮件通知
			EmailModel model = new EmailModel();
			model.setSubject("专家申请");
			model.setEmailType(EmailMsgType.SURVEYTASK);
			model.setContent(content);
			model.setTo(oldAssist.getUser().getEmail());
			notifyService.sendEmail(model);
			
			return DWZUtil.returnSuccessJson("勘查任务已关闭，无需审批！", "assistList","closeCurrent", "survey/assistList/init");
		}
		//插入专家订单
		System.out.println("开始插入专家订单");
		String experts = oldAssist.getExperts();
		Activity activity = oldAssist.getSurveyTask().getActivity();
		OrderForm orderForm = activityService.findOrderByActivity(activity);

		SurveyStep surveyStep = surveyFeedBack.getSurveyStep();
		String step = "1";
		if (SurveyStep.FIRST.equals(surveyStep)) {
			step = "1";
		} else if (SurveyStep.SECOND.equals(surveyStep)) {
			step = "2";
		} else if (SurveyStep.THIRD.equals(surveyStep)) {
			step = "3";
		}

		if (StringUtil.isNotEmpty(experts)) {
			String[] expertArray = experts.split("#");
			for (String expert:expertArray) {
				System.out.println("专家id:"+expert);
				if (StringUtil.isEmpty(expert)) {
					continue;
				}
				User user = baseDao.get(User.class, Long.parseLong(expert));
				ExpertOrderForm expertOrderForm = new ExpertOrderForm();
				expertOrderForm.setUser(user);
				expertOrderForm.setIsSync("0");//待确认
				expertOrderForm.setOrderType("1");
				expertOrderForm.setStep(step);
				expertOrderForm.setOrderForm(orderForm);
				expertOrderForm.setCreateOn(new Date());

				baseDao.saveOrUpdate(expertOrderForm);

				System.out.println("插入专家订单成功");
			}
		}
		if(surveyFeedBackService.saveOrUpdate(surveyFeedBack)){
			String content = "您提交的关于\""+oldAssist.getSurveyTask().getName()+"\"("+oldAssist.getSurveyStep().getName()+")的专家申请已通过审核!";
			notifyService.sendHuaWeiSMS(oldAssist.getUser().getPhone(),content, Const.ENVI_TK, DictConst.SMSCODE_B02,new String[]{oldAssist.getSurveyTask().getName(),oldAssist.getSurveyStep().getName()});
			
			//邮件通知
			EmailModel model = new EmailModel();
			model.setSubject("专家申请");
			model.setEmailType(EmailMsgType.SURVEYTASK);
			model.setContent(content);
			model.setTo(oldAssist.getUser().getEmail());
			notifyService.sendEmail(model);
			
			return DWZUtil.returnSuccessJson(Tips_CN.OP_SUCCEED, "assistList","closeCurrent", "survey/assistList/init");
		} else {
			return DWZUtil.returnFailedJson(Tips_CN.OP_FAILURE, "assistList", "closeCurrent", "");
		}
	}

	@SuppressWarnings("unchecked")
	@Override
	public Map<String, String> transferTask(SurveyAssist surveyAssist) {
		SurveyAssist oldAssist = surveyAssistService.findSurveyAssistByOid(surveyAssist.getOid());
		if(!oldAssist.getAssignStatus().equals(AssignStatus.NON)) {
			return DWZUtil.returnFailedJson("该申请已审批", "assistList", "closeCurrent", "");
		}
		oldAssist.setAssignStatus(surveyAssist.getAssignStatus());
		surveyAssistService.saveOrUpdate(oldAssist);
		
		if(oldAssist.getAssignStatus().equals(AssignStatus.NOTPASS)){
			SurveyTask surveyTask = oldAssist.getSurveyTask();
			surveyTask.setSurveyTaskStatus(SurveyTaskStatus.DOING);
			surveyTaskService.saveOrUpdate(surveyTask);

			String content = "您提交的关于\""+oldAssist.getSurveyTask().getName()+"\"的任务转交没通过审核，请联系项目经理确认！";
			notifyService.sendHuaWeiSMS(oldAssist.getUser().getPhone(),content, Const.ENVI_TK, DictConst.SMSCODE_B03,new String[]{oldAssist.getSurveyTask().getName()});
			
			//邮件通知
			EmailModel model = new EmailModel();
			model.setSubject("任务转交");
			model.setEmailType(EmailMsgType.SURVEYTASK);
			model.setContent(content);
			model.setTo(oldAssist.getUser().getEmail());
			notifyService.sendEmail(model);
			
			return DWZUtil.returnSuccessJson("审批完成", "assistList","closeCurrent", "survey/assistList/init");
		}
		Task task = oldAssist.getSurveyTask().getTask();
		task.setAcceptDate(new Date());
		task.setAssgin(oldAssist.getAccepter());
		task.setAcceptStatus(AcceptStatus.YES.getKey());
		if(taskManageService.saveOrUpdate(task)){
			SurveyTask surveyTask = surveyTaskService.findSurveyTaskByOid(oldAssist.getSurveyTask().getOid()) ;
			surveyTask.setSurveyTaskStatus(SurveyTaskStatus.TRANSFER);
			surveyTaskService.saveOrUpdate(surveyTask);
			surveyTaskService.transferTask(surveyTask);

			String content = "您提交的关于\""+oldAssist.getSurveyTask().getName()+"\"的任务转交已通过审核！";
			notifyService.sendHuaWeiSMS(oldAssist.getUser().getPhone(),content, Const.ENVI_TK, DictConst.SMSCODE_B04,new String[]{oldAssist.getSurveyTask().getName()});
			
			//邮件通知
			EmailModel model = new EmailModel();
			model.setSubject("任务转交");
			model.setEmailType(EmailMsgType.SURVEYTASK);
			model.setContent(content);
			model.setTo(oldAssist.getUser().getEmail());
			notifyService.sendEmail(model);
			
			return DWZUtil.returnSuccessJson("审批完成", "assistList","closeCurrent", "survey/assistList/init");
		}
		else {
			return DWZUtil.returnFailedJson(Tips_CN.OP_FAILURE, "assistList", "closeCurrent", "");
		}
	}
}
