package com.bcxin.survey.filter;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;

import com.bcxin.survey.utils.StringUtil;


public class UrlAuthenticationFailureHandler extends SimpleUrlAuthenticationFailureHandler {
	
	private SecurityRedirect redirect;
	
	private String internalUrl;
	
	private RequestCache		requestCache;

	public UrlAuthenticationFailureHandler() {
		this.requestCache = new HttpSessionRequestCache();
	}
	
	public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
		saveException(request, exception);
		HttpSession session = request.getSession();
		String targetUrl = (String) session.getAttribute("targetUrl");
		if(StringUtil.isEmpty(targetUrl)){
			SavedRequest savedRequest = this.requestCache.getRequest(request, response);
			if(savedRequest != null){
				targetUrl = savedRequest.getRedirectUrl();// 获取登录访问前的URL
				System.out.println("登录失败，登录前访问地址："+targetUrl);
			    session.setAttribute("targetUrl",targetUrl);// 保存获取登录访问前的URL
			}
		}
		
		setDefaultFailureUrl("/manage/login");
        super.onAuthenticationFailure(request, response, exception);
	 }

	public SecurityRedirect getRedirect() {
		return redirect;
	}

	public void setRedirect(SecurityRedirect redirect) {
		this.redirect = redirect;
	}

	public String getInternalUrl() {
		return internalUrl;
	}

	public void setInternalUrl(String internalUrl) {
		this.internalUrl = internalUrl;
	}
	
}
