package com.bcxin.survey.enums.report;



public enum FieldType {
	
	INPUT {public String getValue(){return "0";} public String getName(){return "单行文本";} public String getEname(){return "INPUT";}}, 

	TEXTAREA{public String getValue(){return "1";} public String getName(){return "多行文本";}public String getEname(){return "TEXTAREA";}},
	
	CHECKBOX{public String getValue(){return "2";} public String getName(){return "多选框";}public String getEname(){return "CHECKBOX";}},
	
	RADIO{public String getValue(){return "3";} public String getName(){return "单选框";}public String getEname(){return "RADIO";}},
	
	SELECT{public String getValue(){return "4";} public String getName(){return "下拉框";}public String getEname(){return "SELECT";}},
	
	IMAGE{public String getValue(){return "5";} public String getName(){return "图片控件";}public String getEname(){return "IMAGE";}},
	
	FILE{public String getValue(){return "6";} public String getName(){return "文件控件";}public String getEname(){return "FILE";}},
	
	BUTTON{public String getValue(){return "7";} public String getName(){return "按钮";}public String getEname(){return "BUTTON";}},
	
	DATE{public String getValue(){return "8";} public String getName(){return "时间控件";}public String getEname(){return "DATE";}},
	
	MIMAGE{public String getValue(){return "9";} public String getName(){return "多图控件";}public String getEname(){return "MIMAGE";}},

	HIDDEN{public String getValue(){return "10";} public String getName(){return "隐藏控件";}public String getEname(){return "HIDDEN";}};


    public abstract String getValue();
    
    public abstract String getName();
    
    public abstract String getEname();
    
    
    public static FieldType convertValue(String value){
      	 if("0".equals(value)){return FieldType.INPUT;}
	   	 else if("1".equals(value)){return FieldType.TEXTAREA;}
	   	 else if("2".equals(value)){return FieldType.CHECKBOX;}
	   	 else if("3".equals(value)){return FieldType.RADIO;}
	   	 else if("4".equals(value)){return FieldType.SELECT;}
	   	 else if("5".equals(value)){return FieldType.IMAGE;}
	   	 else if("6".equals(value)){return FieldType.FILE;}
	   	 else if("7".equals(value)){return FieldType.BUTTON;}
	   	 else if("8".equals(value)){return FieldType.DATE;}
	   	 else if("9".equals(value)){return FieldType.MIMAGE;}
	   	 else if("10".equals(value)){return FieldType.HIDDEN;}
	   	 else{return null;}
	}
    
    public static FieldType convertName(String name){
    	if ( "单行文本".equals(name) ) {
    		return FieldType.INPUT;
    	} else if ("多行文本".equals(name)) {
    		return FieldType.TEXTAREA;
    	} else if ("多选框".equals(name)) {
    		return FieldType.CHECKBOX;
    	} else if ("单选框".equals(name)) {
    		return FieldType.RADIO;
    	} else if ("下拉框".equals(name)) {
    		return FieldType.SELECT;
    	} else if ("图片控件".equals(name)) {
    		return FieldType.IMAGE;
    	} else if ("文件控件".equals(name)) {
    		return FieldType.FILE;
    	} else if ("按钮".equals(name)) {
    		return FieldType.BUTTON;
    	} else if ("时间控件".equals(name)) {
    		return FieldType.DATE;
    	} else if ("多图控件".equals(name)) {
    		return FieldType.MIMAGE;
    	}  else if ("隐藏控件".equals(name)) {
    		return FieldType.HIDDEN;
    	} 

    	return null;
    }
    
    
    public static boolean isFileField(FieldType field){
    	if ( FieldType.IMAGE.equals(field) 
			|| FieldType.FILE.equals(field) 
			|| FieldType.MIMAGE.equals(field)) {
    		return true;
    	}
    	return false;
    }
    

    public static boolean isShowInWord(FieldType field){
    	if ( FieldType.IMAGE.equals(field) 
    			|| FieldType.CHECKBOX.equals(field) 
    			|| FieldType.DATE.equals(field)
				|| FieldType.INPUT.equals(field) 
				|| FieldType.RADIO.equals(field)
    			|| FieldType.SELECT.equals(field) 
    			|| FieldType.TEXTAREA.equals(field)
				|| FieldType.MIMAGE.equals(field)) {
    		return true;
    	}
    	return false;
    }
}
