package com.bcxin.survey.enums.report;


public enum AcceptStatus {

	NON("0","未接受"),
	YES("1","已接受"),
	TRANSFER("2","申请转交");

	private String key;
	private String alias;

	AcceptStatus(String key, String alias){
		this.key=key;
		this.alias=alias;
	}

	public String getKey(){
		return this.key;
	}

	public String getAlias(){
		return this.alias;
	}

	public String getName(){return this.alias;}

	public static String getAlias(String key){
		for(AcceptStatus e : AcceptStatus.values()){
			if(e.getKey().equals(key)){
				return e.getAlias();
			}
		}
		return "";
	}


//	NON {public String getValue(){return "0";} public String getName(){return "未接受";}},
//
//	YES{public String getValue(){return "1";} public String getName(){return "已接受";}},
//
//	/** 已转交 */
//	TRANSFER {public String getValue(){return "2";} public String getName(){return "申请转交";}};
//
//    public abstract String getValue();
//
//    public abstract String getName();
//
//    public static AcceptStatus convert(String value){
//    	if ( "0".equals(value) ) {
//    		return AcceptStatus.NON;
//    	} else if ("1".equals(value)) {
//    		return AcceptStatus.YES;
//    	}else if ("2".equals(value)) {
//    		return AcceptStatus.TRANSFER;
//    	}
//    	return null;
//    }
 
}
