package com.bcxin.survey.dto;

import java.util.ArrayList;
import java.util.List;

/**
 * 搜索类基类
 * @author Ethan
 */
public class SearchDto<T> {
	protected String keyword;
	protected List<T> data = new ArrayList<T>();
	//分页参数开始
	protected boolean paging = true;//是否分页,默认分页
	protected Integer pageNum;//页数
	protected Integer numPerPage;//每页显示几条
	protected Long totalCount=0L;


	private Long userid;

	private  String path;



	/**
	 * 所在地县（区）代码
	 **/
	private String district;
	
	private String sort;//排序字段
	
	private String order;//排序 asc 顺序 or 倒序desc


	public Long getUserid() {
		return userid;
	}

	public void setUserid(Long userid) {
		this.userid = userid;
	}

	public String getPath() {
		return path;
	}

	public void setPath(String path) {
		this.path = path;
	}

	public String getDistrict() {
		return district;
	}

	public void setDistrict(String district) {
		this.district = district;
	}

	public String getKeyword() {
		return keyword;
	}

	public void setKeyword(String keyword) {
		this.keyword = keyword;
	}

	public boolean isPaging() {
		return paging;
	}

	public void setPaging(boolean paging) {
		this.paging = paging;
	}
	
	public Integer getPageNum() {
		return pageNum;
	}

	public void setPageNum(Integer pageNum) {
		this.pageNum = pageNum;
	}

	public Integer getNumPerPage() {
		return numPerPage;
	}

	public void setNumPerPage(Integer numPerPage) {
		this.numPerPage = numPerPage;
	}

	public Long getTotalCount() {
		return totalCount;
	}

	public void setTotalCount(Long totalCount) {
		this.totalCount = totalCount;
	}

	public Integer getStart() {
		return (this.pageNum == null ? 0:this.pageNum) * (this.numPerPage == null ? 0:this.numPerPage);
	}

	public List<T> getData() {
		return data;
	}

	public void setData(List<T> data) {
		this.data = data;
	}

	public String getSort() {
		return sort;
	}

	public void setSort(String sort) {
		this.sort = sort;
	}

	public String getOrder() {
		return order;
	}

	public void setOrder(String order) {
		this.order = order;
	}

}
