package com.bcxin.survey.domain.wechat;

import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;

import org.hibernate.annotations.Proxy;

import com.bcxin.survey.domain.BaseBean;
import com.bcxin.survey.enums.report.BillMsgType;


/**
 * 微信通用接口凭证
 * 
 * 
 * @date 2014-11-24
 */

@Entity
@Table(name = "wechat_AccessToken")
@Inheritance(strategy = InheritanceType.JOINED)
@Proxy(proxyClass = AccessToken.class)
public class AccessToken extends BaseBean{
	/**
	 * 
	 */
	private static final long	serialVersionUID	= 1L;
	// 获取到的凭证
	private String token;
	// 凭证有效时间，单位：秒
	private int expiresIn;
	
	@Enumerated(EnumType.STRING)
	private BillMsgType type;//token类型
	
	public String getToken() {
		return token;
	}

	public void setToken(String token) {
		this.token = token;
	}

	public int getExpiresIn() {
		return expiresIn;
	}

	public void setExpiresIn(int expiresIn) {
		this.expiresIn = expiresIn;
	}

	public BillMsgType getType() {
		return type;
	}

	public void setType(BillMsgType type) {
		this.type = type;
	}
}