package com.bcxin.survey.domain.survey;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;

import com.bcxin.survey.enums.report.QuestionStatusEnum;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Proxy;

import com.bcxin.survey.domain.BaseBean;
import com.bcxin.survey.domain.activity.Venue;
import com.bcxin.survey.enums.report.SurveyStep;
import com.bcxin.survey.enums.report.TaskStatus;

@Entity
@Table(name = "RISK_Survey_Questionnaire")
@Inheritance(strategy = InheritanceType.JOINED)
@Proxy(proxyClass = Survey_Questionnaire.class)
@DynamicInsert(true)
@DynamicUpdate(true)
public class Survey_Questionnaire extends BaseBean{

	private static final long serialVersionUID = 1L;

	@ManyToOne(targetEntity = Survey_FeedBack.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "feedBackId")
	private Survey_FeedBack feedBack = new Survey_FeedBack(); //对应勘察阶段
	
	@Enumerated(EnumType.STRING)
	private SurveyStep surveyStep;//勘察阶段
	
	//各勘察项目明细
	@OneToMany(targetEntity = Survey_Info.class, cascade = CascadeType.REMOVE, mappedBy="questionnaire", fetch = FetchType.LAZY)
	@OrderBy("sort,oid asc")
    private List<Survey_Info> surveyInfos = new ArrayList<Survey_Info>();

	@ManyToOne(targetEntity = Venue.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "venueId")
    private Venue venue = new Venue();

	// 问卷状态
	@Enumerated(EnumType.STRING)
	private QuestionStatusEnum taskStatus;
	
	private Date beginTime;//查勘开始时间
	
	private Date endTime;//查勘结束时间

	private boolean correction = false;//是否整改
	
	private boolean generate = false;//是否生成问卷
	
	private String reportPath;

	//勘查计划
	@OneToMany(targetEntity = SurveyPlan.class, mappedBy="questionnaire", fetch = FetchType.LAZY)
    private List<SurveyPlan> surveyPlans = new ArrayList<SurveyPlan>();
	
	public Survey_FeedBack getFeedBack() {
		return feedBack;
	}

	public void setFeedBack(Survey_FeedBack feedBack) {
		this.feedBack = feedBack;
	}

	public List<Survey_Info> getSurveyInfos() {
		return surveyInfos;
	}

	public void setSurveyInfos(List<Survey_Info> surveyInfos) {
		this.surveyInfos = surveyInfos;
	}

	public Venue getVenue() {
		return venue;
	}

	public void setVenue(Venue venue) {
		this.venue = venue;
	}

	public QuestionStatusEnum getTaskStatus() {
		return taskStatus;
	}

	public void setTaskStatus(QuestionStatusEnum taskStatus) {
		this.taskStatus = taskStatus;
	}

	public Date getBeginTime() {
		return beginTime;
	}

	public void setBeginTime(Date beginTime) {
		this.beginTime = beginTime;
	}

	public Date getEndTime() {
		return endTime;
	}

	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}

	public SurveyStep getSurveyStep() {
		return surveyStep;
	}

	public void setSurveyStep(SurveyStep surveyStep) {
		this.surveyStep = surveyStep;
	}

	public boolean isCorrection() {
		return correction;
	}

	public void setCorrection(boolean correction) {
		this.correction = correction;
	}

	public boolean isGenerate() {
		return generate;
	}

	public void setGenerate(boolean generate) {
		this.generate = generate;
	}

	public String getReportPath() {
		return reportPath;
	}

	public void setReportPath(String reportPath) {
		this.reportPath = reportPath;
	}

	public List<SurveyPlan> getSurveyPlans() {
		return surveyPlans;
	}

	public void setSurveyPlans(List<SurveyPlan> surveyPlans) {
		this.surveyPlans = surveyPlans;
	}

}
