package com.bcxin.survey.domain.survey;

import java.util.ArrayList;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Proxy;

import com.fasterxml.jackson.annotation.JsonBackReference;


/**
 * 查勘现场具体问题及反馈详情
 * @author luopeng
 *
 */
@Entity
@Table(name = "RISK_Survey_Info")
@Inheritance(strategy = InheritanceType.JOINED)
@Proxy(proxyClass = Survey_Info.class)
@DynamicInsert(true)
@DynamicUpdate(true)
public class Survey_Info extends SurveyProject {
	 
	private static final long	serialVersionUID	= 1L;

	@ManyToOne(targetEntity = Survey_Questionnaire.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "questionnaireId")
	@JsonBackReference
	private Survey_Questionnaire questionnaire = new Survey_Questionnaire();	
	
	private String answer; //结果
	
	private boolean nextSurvey = false;
		
	@OneToMany(targetEntity = Survey_Photo.class, cascade = CascadeType.REMOVE,mappedBy="surveyInfo")
    private List<Survey_Photo> photos = new ArrayList<Survey_Photo>();
    
    private String lastSurveyInfoId;
    
	@ManyToOne(targetEntity = SurveyReform.class, fetch = FetchType.LAZY,cascade=CascadeType.ALL )
	@JoinColumn(name = "reformId")
	private SurveyReform surveyReform = new SurveyReform();	
	
    private boolean replied;//该问题是否已回答
    
    @Transient
    private boolean existence;

    @Transient
    private Survey_Info lastSurvey;
    
	public Survey_Questionnaire getQuestionnaire() {
		return questionnaire;
	}

	public void setQuestionnaire(Survey_Questionnaire questionnaire) {
		this.questionnaire = questionnaire;
	}

	public String getAnswer() {
		return answer;
	}

	public void setAnswer(String answer) {
		this.answer = answer;
	}

	public List<Survey_Photo> getPhotos() {
		return photos;
	}

	public void setPhotos(List<Survey_Photo> photos) {
		this.photos = photos;
	}

	public boolean isNextSurvey() {
		return nextSurvey;
	}

	public void setNextSurvey(boolean nextSurvey) {
		this.nextSurvey = nextSurvey;
	}

	public boolean isReplied() {
		return replied;
	}

	public void setReplied(boolean replied) {
		this.replied = replied;
	}

	public boolean isExistence() {
		return existence;
	}

	public void setExistence(boolean existence) {
		this.existence = existence;
	}

	public SurveyReform getSurveyReform() {
		return surveyReform;
	}

	public void setSurveyReform(SurveyReform surveyReform) {
		this.surveyReform = surveyReform;
	}

	public String getLastSurveyInfoId() {
		return lastSurveyInfoId;
	}

	public void setLastSurveyInfoId(String lastSurveyInfoId) {
		this.lastSurveyInfoId = lastSurveyInfoId;
	}

	public Survey_Info getLastSurvey() {
		return lastSurvey;
	}

	public void setLastSurvey(Survey_Info lastSurvey) {
		this.lastSurvey = lastSurvey;
	}
	
}
