package com.bcxin.survey.domain.survey;

import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;

import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Proxy;

import com.bcxin.survey.domain.BaseBean;
import com.bcxin.survey.enums.report.QuestionType;
import com.bcxin.survey.enums.report.SurveyStep;

/**
 * 勘查项目//数据来源cms中的dede_addon32表(开放问题)、dede_addon41(固定问题)
 * @author BCXIN
 *
 */
@Entity
@Table(name = "RISK_SurveyProject")
@Inheritance(strategy = InheritanceType.JOINED)
@Proxy(proxyClass = SurveyProject.class)
@DynamicInsert(true)
@DynamicUpdate(true)
public class SurveyProject extends BaseBean{

	private static final long	serialVersionUID	= 1L;
	
	
	@Enumerated(EnumType.STRING)
	private SurveyStep surveyStep;//勘察阶段
	
	private String question;//勘查题目

	private String answerTip;//结果提示
	
	@Enumerated(EnumType.STRING)
	private QuestionType questionType;//问题类型
	
	private String aid;//cms中对应的问题ID
	
	private long sort = 0;//排序编号


	public SurveyStep getSurveyStep() {
		return surveyStep;
	}

	public void setSurveyStep(SurveyStep surveyStep) {
		this.surveyStep = surveyStep;
	}


	public String getQuestion() {
		return question;
	}

	public void setQuestion(String question) {
		this.question = question;
	}

	public String getAnswerTip() {
		return answerTip;
	}

	public void setAnswerTip(String answerTip) {
		this.answerTip = answerTip;
	}

	public QuestionType getQuestionType() {
		return questionType;
	}

	public void setQuestionType(QuestionType questionType) {
		this.questionType = questionType;
	}

	public String getAid() {
		return aid;
	}

	public void setAid(String aid) {
		this.aid = aid;
	}

	public long getSort() {
		return sort;
	}

	public void setSort(long sort) {
		this.sort = sort;
	}
}
