package com.bcxin.survey.domain.survey;

import com.bcxin.survey.domain.BaseBean;
import com.bcxin.survey.domain.activity.Venue;
import com.bcxin.survey.domain.security.User;
import com.bcxin.survey.enums.report.PlanStatusEnum;
import com.bcxin.survey.enums.report.SurveyStep;
import com.bcxin.survey.enums.report.TaskStatus;
import com.fasterxml.jackson.annotation.JsonBackReference;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Proxy;

import javax.persistence.*;
import java.util.Date;

/**
 * 勘查计划
 * @author luopeng
 *
 */
@Entity
@Table(name = "RISK_SurveyPlan")
@Inheritance(strategy = InheritanceType.JOINED)
@Proxy(proxyClass = SurveyPlan.class)
@DynamicInsert(true)
@DynamicUpdate(true)
public class SurveyPlan extends BaseBean{


	private static final long serialVersionUID = 1L;

	@ManyToOne(targetEntity = SurveyTask.class, fetch = FetchType.EAGER)
	@JoinColumn(name = "taskId")
	private SurveyTask surveyTask; //对应勘察任务

	// 勘察员工号
	@ManyToOne(targetEntity = User.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "userId")
	@JsonBackReference
	private User user = new User();
	
	private int time;//勘查次数

	@Enumerated(EnumType.STRING)
	private SurveyStep surveyStep;//勘察阶段
	
	@ManyToOne(targetEntity = Survey_FeedBack.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "feedBackId")
	private Survey_FeedBack feedBack = new Survey_FeedBack(); //对应勘查阶段

	@ManyToOne(targetEntity = Survey_Questionnaire.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "questionnaireId")
	@JsonBackReference
	private Survey_Questionnaire questionnaire;	//对应勘查场地问题
	
	@ManyToOne(targetEntity = Venue.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "venueId")
    private Venue venue = new Venue();

	// 踏勘计划任务状态
	@Enumerated(EnumType.STRING)
	private PlanStatusEnum taskStatus;
	
	private Date beginTime;//查勘开始时间
	
	private Date endTime;//查勘结束时间

	private boolean allDay;
	
	private String remark;//备注

    private String signImgPath;//勘查人员签名
    
    private String purveyorSignPath;//承办方负责人签名

    @Transient
    private boolean sign=false;
    
	public SurveyTask getSurveyTask() {
		return surveyTask;
	}

	public void setSurveyTask(SurveyTask surveyTask) {
		this.surveyTask = surveyTask;
	}

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

	public int getTime() {
		return time;
	}

	public void setTime(int time) {
		this.time = time;
	}

	public SurveyStep getSurveyStep() {
		return surveyStep;
	}

	public void setSurveyStep(SurveyStep surveyStep) {
		this.surveyStep = surveyStep;
	}
	
	public Survey_FeedBack getFeedBack() {
		return feedBack;
	}

	public void setFeedBack(Survey_FeedBack feedBack) {
		this.feedBack = feedBack;
	}
	
	public PlanStatusEnum getTaskStatus() {
		return taskStatus;
	}

	public void setTaskStatus(PlanStatusEnum taskStatus) {
		this.taskStatus = taskStatus;
	}

	public Date getBeginTime() {
		return beginTime;
	}

	public void setBeginTime(Date beginTime) {
		this.beginTime = beginTime;
	}

	public Date getEndTime() {
		return endTime;
	}

	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}

	public boolean isAllDay() {
		return allDay;
	}

	public void setAllDay(boolean allDay) {
		this.allDay = allDay;
	}

	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public String getSignImgPath() {
		return signImgPath;
	}

	public void setSignImgPath(String signImgPath) {
		this.signImgPath = signImgPath;
	}

	public String getPurveyorSignPath() {
		return purveyorSignPath;
	}

	public void setPurveyorSignPath(String purveyorSignPath) {
		this.purveyorSignPath = purveyorSignPath;
	}

	public Survey_Questionnaire getQuestionnaire() {
		return questionnaire;
	}

	public void setQuestionnaire(Survey_Questionnaire questionnaire) {
		this.questionnaire = questionnaire;
	}

	public Venue getVenue() {
		return venue;
	}

	public void setVenue(Venue venue) {
		this.venue = venue;
	}

	public boolean isSign() {
		return sign;
	}

	public void setSign(boolean sign) {
		this.sign = sign;
	}

}
