package com.bcxin.survey.domain.security;

import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import com.bcxin.survey.domain.BaseBean;

import javax.persistence.*;

/**
 * 用户角色表
 */
@Entity
@Table(name = "RISK_User_Role")
@Inheritance(strategy = InheritanceType.JOINED)
@DynamicInsert(true)
@DynamicUpdate(true)
public class UserRole extends BaseBean {

	private static final long serialVersionUID = 1L;

	@ManyToOne(targetEntity = User.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "user_id")
	private User user; //所属用户

	@ManyToOne(targetEntity = Role.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "role_id")
	private Role role; //所属角色

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

	public Role getRole() {
		return role;
	}

	public void setRole(Role role) {
		this.role = role;
	}
	
}
