package com.bcxin.survey.domain.data;

import com.bcxin.survey.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;

/**
 * 材料生成任务
* 记录活动对应的材料生成，如果没有生成，则需要定时任务重新生成
* @Description: 
* @date: 2018年08月27日 上午11:10:51
* @author 罗鹏
 */
@Entity
@Table(name = "RISK_MaterialTask")
@Inheritance(strategy = InheritanceType.JOINED)
@DynamicInsert(true)
@DynamicUpdate(true)
@Data
public class MaterialTask extends BaseBean {

	private static final long serialVersionUID = 1L;

    /**
     * 归属的活动编号
	 */
	private String activityNo;

	/**
	 * 同步类型（字典）
	 */
	private String materialTaskType;

	/**
	 * 同步状态是否成功
	 */
	private String success;

	/**
	 * 附加内容
	 */
	private String content;

}
