package com.bcxin.survey.domain;

import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * 基础类，所有类的父类，提供主键、创建时间、修改时间
 * @author luopeng
 *
 */
@MappedSuperclass
public class BaseBean implements Serializable {

	private static final long serialVersionUID = 1L;

	///**
	// * 主键
	// */
	//@Id
	//@GeneratedValue(generator = "hilo")
	//@GenericGenerator(name = "hilo", strategy = "hilo")
	//@Column(unique = true, nullable = false)
	//private Long oid;

	/**
	 * 主键
	 */
	@Id
	@GeneratedValue(generator = "identity")
	@GenericGenerator(name = "identity", strategy = "identity")
	@Column(unique = true, nullable = false)
	private Long oid;
	
	/**
	 * 创建时间
	 */
	@Temporal(TemporalType.TIMESTAMP)
	private Date createOn;
	
	/**
	 * 修改时间
	 */
	@Temporal(TemporalType.TIMESTAMP)
	private Date updateOn;

	public BaseBean() {
		 
	}
	
	public Long getOid() {
		return oid;
	}

	public void setOid(Long oid) {
		this.oid = oid;
	}

	public Date getCreateOn() {
		return createOn;
	}

	public void setCreateOn(Date createOn) {
		this.createOn = createOn;
	}

	public Date getUpdateOn() {
		return updateOn;
	}

	public void setUpdateOn(Date updateOn) {
		this.updateOn = updateOn;
	}

}
