package com.bcxin.survey.dao.report;

import cn.hutool.core.date.DateUtil;
import com.bcxin.survey.domain.data.SyncTask;
import com.bcxin.survey.utils.DictConst;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Repository
public class SyncTaskDaoImpl extends BaseDaoImpl implements SyncTaskDao {

    @Override
    public List<SyncTask> findUnCompleteTask(){
        List<Criterion> criterionList = new ArrayList<Criterion>();
        criterionList.add(Restrictions.eq("success", DictConst.N));
        /* 取30分钟之前的，防止正在同步的任务重复同步 */
        criterionList.add(Restrictions.lt("createOn", "'"+ DateUtil.offsetMinute(new Date(),-30)+"'"));
        return 	findByCriterion(SyncTask.class, criterionList);
    }

}
