package com.bcxin.survey.dao.report;

import com.bcxin.survey.domain.activity.Activity;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;


@Repository("activityDao")
public class ActivityDaoImpl extends BaseDaoImpl implements ActivityDao {


    @Override
    public Activity findActivityByOid(Long oid){
        return findByCriterionToUnique(Activity.class, Restrictions.eq("oid", oid));
    }


    @Override
    public Activity findActivityByActivityNo(String activityNo) {
        return findByCriterionToUnique(Activity.class, Restrictions.eq("activityNo", activityNo));
    }
}
