package com.bcxin.survey.dao.order;

import com.bcxin.survey.dao.report.BaseDaoImpl;
import com.bcxin.survey.domain.order.ExpertOrderPublic;
import com.bcxin.survey.enums.expert.ExpertTaskStatusEnum;
import com.bcxin.survey.utils.CollectionUtil;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author hzp
 * 共享专家订单DAO层
 */
@Repository("expertOrderPublicDao")
public class ExpertOrderPublicDaoImpl extends BaseDaoImpl implements ExpertOrderPublicDao {

    @Override
    public ExpertOrderPublic findExpertByIdWithActivity(Long activityId, Long expertId, String taskType){
        List<Criterion> criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.eq("activityId", activityId));
        criterionList.add(Restrictions.eq("userId", expertId));
        criterionList.add(Restrictions.eq("taskType", taskType));
        List list =this.findByCriterion(ExpertOrderPublic.class,criterionList);
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        return (ExpertOrderPublic)list.get(0);
    }

    /**
     * 根据活动+类型更新状态，只更新未接单和拒绝的状态
     * @param activityId
     * @param taskType
     * @param taskStatus
     */
    @Override
    public void updateStatusToCancel(Long activityId,String taskType,String taskStatus){
        String sql="update risk_expertorderform_public set taskStatus='"+taskStatus+"' ";
        sql+=" where activityId="+activityId+" and taskType='"+taskType+"'";
        sql+=" and taskStatus in ('"+ExpertTaskStatusEnum.UN_ACCEPT.getKey()+"','"+ExpertTaskStatusEnum.REFUSE.getKey()+"')";
        this.executeUpdate(sql);
    }

    @Override
    public void updateStatus(Long activityId,Long expertId,String taskType,String taskStatus){
        String sql="update risk_expertorderform_public set taskStatus='"+taskStatus+"' ";
        sql+=" where activityId="+activityId+" and taskType='"+taskType+"'";
        sql+=" and userId="+expertId;
        int num=this.executeUpdate(sql);
    }
}