package com.bcxin.survey.controller.wechat;

import com.bcxin.survey.base.BaseController;
import com.bcxin.survey.dao.report.TaskDao;
import com.bcxin.survey.domain.activity.Activity;
import com.bcxin.survey.domain.report.Task;
import com.bcxin.survey.domain.security.User;
import com.bcxin.survey.domain.survey.SurveyAssist;
import com.bcxin.survey.domain.survey.SurveyPlan;
import com.bcxin.survey.domain.survey.SurveyTask;
import com.bcxin.survey.domain.survey.Survey_FeedBack;
import com.bcxin.survey.enums.report.*;
import com.bcxin.survey.service.CommonService;
import com.bcxin.survey.service.UserService;
import com.bcxin.survey.service.report.ActivityService;
import com.bcxin.survey.service.wechat.SurveyAssistService;
import com.bcxin.survey.service.wechat.SurveyFeedBackService;
import com.bcxin.survey.service.wechat.SurveyPlanService;
import com.bcxin.survey.service.wechat.SurveyTaskService;
import com.bcxin.survey.utils.CollectionUtil;
import com.bcxin.survey.utils.DictConst;
import com.bcxin.survey.utils.StringUtil;
import com.bcxin.survey.vo.DwzPage;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Controller
@RequestMapping("/wechat/task")
public class WechatTaskController extends BaseController {

	@Autowired
	private UserService userService;
	@Autowired
	private TaskDao taskDao;
	
	@Autowired
	private SurveyTaskService surveyTaskService;
		
	@Autowired
	private SurveyFeedBackService surveyFeedBackService;
	
	@Autowired
	private SurveyAssistService surveyAssistService;	

	@Autowired
	private SurveyPlanService surveyPlanService;

	@Autowired
	private ActivityService activityService;

	@Autowired
	private CommonService commonService;


	private List<SurveyTask> selectExpert(List<SurveyTask> taskList) {
		//查询专家信息，并暂存于SurveyTask对象
		if (CollectionUtil.isNotEmpty(taskList)) {
			List<Long> taskIdList = new ArrayList<>();
			for (SurveyTask surveyTask : taskList) {
				taskIdList.add(surveyTask.getOid());
			}
			List<Map<String, Object>> listExpert = surveyTaskService.selectExpertBySurveyTaskIdList(taskIdList);
			if (CollectionUtil.isNotEmpty(listExpert)) {
				User expert = new User();
				for (SurveyTask surveyTask : taskList) {
					for (Map<String, Object> map : listExpert) {
						if (surveyTask.getTask() != null) {
							if (surveyTask.getTask().getOid() != null && map.get("taskId") != null) {
								if (surveyTask.getTask().getOid().toString().equals(map.get("taskId").toString())) {
									expert.setRealName(map.get("realName").toString());
									expert.setPhone(map.get("phone").toString());
									surveyTask.setUser(expert);
								}
							}else{
								surveyTask.setUser(new User());
							}
						}
					}
				}
			}
			return taskList;
		}
		return null;
	}
	/**
	 * 我的任务 页面初始化
	 * @param request
	 * @return
	 */
	@RequestMapping("taskList/init")
	public ModelAndView taskList(HttpServletRequest request,DwzPage page){
		ModelAndView view = new ModelAndView("wechat/task/taskList");
		User user=  userService.getCurrentUser();
		if (user != null) {
			page.setNumPerPage(10);
//			List<SurveyTask> taskList = surveyTaskService.findSurveyTaskListByUserAndStatusForPage(user, null, SurveyTaskStatus.DISTRIBUTE,page);

			List<Map<String,Object>> taskList = surveyTaskService.findSurveyTaskListByUserForPage(user, null, SurveyTaskStatus.DISTRIBUTE,page);
			//查询专家信息，并暂存于SurveyTask对象
//			taskList = selectExpert(taskList);
			view.addObject("taskList",taskList);
			view.addObject("user",user);
		}
		return view;
	}

	@RequestMapping("gettaskListForPage")
	public ModelAndView gettaskListForPage(HttpServletRequest request,DwzPage page){
		ModelAndView view = new ModelAndView("wechat/task/taskList_table");
		User user= (User) userService.getCurrentUser();
		if(user != null ){				  
			List<SurveyTask> taskList = surveyTaskService.findSurveyTaskListByUserAndStatusForPage(user, null, null,page);
			view.addObject("taskList",taskList);
		}
		return view;
	}
	

	@RequestMapping("gettaskListByStatusForPage")
	public ModelAndView gettaskListByStatusForPage(SurveyTaskStatus surveyTaskStatus,HttpServletRequest request,DwzPage page){
		ModelAndView view = new ModelAndView("wechat/task/taskListByStatus");
		User user= userService.getCurrentUser();
		if(user != null ){
			String search = request.getParameter("search"); 
//			List<SurveyTask> taskList = surveyTaskService.findSurveyTaskListByUserAndStatusForPage(user, search,surveyTaskStatus,page);
			List<Map<String,Object>> taskList=surveyTaskService.findSurveyTaskListByUserForPage(user, search,surveyTaskStatus,page);

			//查询专家信息，并暂存于SurveyTask对象
//			taskList = selectExpert(taskList);
			view.addObject("taskList",taskList);
			view.addObject("surveyTaskStatus",surveyTaskStatus);
		}
		return view;
	}
	
	
	/**
	 * 接受任务 业务处理
	 * @param taskId
	 * @return
	 */
	@RequestMapping("receiveTask")
	public JSONObject receiveTask(Long taskId){
		return surveyTaskService.receiveTask(taskId);
	}
	
	/**
	 * 拒绝任务 业务处理
	 * @param taskId
	 * @return
	 */
	@RequestMapping("refuseTask")
	public JSONObject refuseTask(Long taskId){
		return surveyTaskService.refuseTask(taskId);
	}

	/**
	 * 任务转交 页面初始化
	 * @param taskId
	 * @return
	 */
	@RequestMapping("transferTask/init")
	public ModelAndView transferTaskInit(Long taskId){
		ModelAndView view = new ModelAndView("wechat/task/transferTask");
		User currentUser = userService.getCurrentUser();
		SurveyTask surveyTask = surveyTaskService.findSurveyTaskByOid(taskId);
		if(surveyTask.getSurveyTaskStatus().equals(SurveyTaskStatus.TRANSFERAUDIT)){
			view.addObject("surveyAssist",surveyAssistService.findSurveyAssistByTaskAndStepAndStatus(surveyTask, null, AssignStatus.NON,AssignType.TRANSFERTASK));
		}
		view.addObject("surveyTask", surveyTask);
//		List<User> userList= userService.findUserListByOrgIdAndUserType(currentUser.getOrg().getOid(),DictConst.USERTYPE_CM);
		Long orgId=commonService.getFengPingOrg(surveyTask.getActivity());
		List<User> userList= userService.findExpertUser(orgId,DictConst.USERTYPE_CM);
		view.addObject("userList", userList);
		view.addObject("user", currentUser);
		return view;
	}
	
	/**
	 * 任务转交 业务处理
	 * @return
	 */
	@RequestMapping("transferTask")
	public JSONObject transferTask(SurveyAssist surveyAssist){
		User user = userService.getCurrentUser();
		surveyAssist.setUser(user);
		return surveyAssistService.transferTask(surveyAssist);
	}

	/**
	 * 申请专家 页面初始化
	 * @param taskId
	 * @return
	 */
	@RequestMapping("applyExpert/init")
	public ModelAndView applyExpertInit(Long taskId){
		ModelAndView view = new ModelAndView("wechat/task/applyExpert");
		User user =  userService.getCurrentUser();
		SurveyTask surveyTask = surveyTaskService.findSurveyTaskByOid(taskId);
		Activity activity = surveyTask.getActivity();
		Long activityOid = activity.getOid();

		Long orgId=commonService.getFengPingOrg(activity);

		view.addObject("surveyTask", surveyTask);
//		view.addObject("stepList",SurveyStep.values());
		view.addObject("stepList",taskDao.selectApplyExpertStep(surveyTask.getTask().getOid()));
		view.addObject("user", user);
		view.addObject("taskList",surveyTaskService.findUnFinishedSurveyTaskListByUser(user));
//		view.addObject("expertList",userService.findSurveyExpertUser(activity));
		view.addObject("expertList",userService.findExpertUser(orgId,"17"));
		view.addObject("activityOid",activityOid);
		return view;
	}
	
	/**
	 * 申请专家 业务处理
	 * @param surveyAssist
	 * @return
	 */
	@RequestMapping("applyExpert")
	public JSONObject applyExpert(SurveyAssist surveyAssist, HttpServletRequest request,String activityOid){
		User user = userService.getCurrentUser();
		surveyAssist.setUser(user);
		String expertsStr = request.getParameter("experts");
		System.out.println("专家订单测试，收到专家ids1:"+expertsStr.toString());
		StringBuffer expertBuffer = new StringBuffer();
		int loop = 0;
		String[] experts = expertsStr.split("#");
		for (String expert : experts) {
			if (StringUtil.isEmpty(expert)) {
				continue;
			}
			if(loop == 0) {
				expertBuffer.append(expert);
			} else{
				expertBuffer.append("#").append(expert);
			}
			loop++;
		}
		System.out.println("专家订单测试，收到专家ids2:"+expertBuffer.toString());
		surveyAssist.setExperts(expertBuffer.toString());
		return surveyAssistService.applyExpert(surveyAssist);
	}
	
	/**
	 * 查询勘查计划阶段
	 * @param taskId
	 * @return
	 */
	@RequestMapping("findFeedBackListByTaskId")
	public JSONObject findFeedBackListByTaskId(long taskId){
		JSONObject json = new JSONObject();
		JSONArray feedBackArr = new  JSONArray();
		List<Survey_FeedBack> feedBacks = surveyFeedBackService.findSurvey_FeedBackByTaskId(taskId);
		for (Survey_FeedBack feedBack : feedBacks) {
			JSONObject obj = new JSONObject();
			obj.put("oid", feedBack.getOid());
			obj.put("surveyStep", feedBack.getSurveyStep());
			feedBackArr.add(obj);
		}
		String status = "200";
		json.put("status", status);
		json.put("feedBacks", feedBackArr);
		return json;
	}
	
	/**
	 * 查询勘查计划阶段
	 * @param taskId
	 * @return
	 */
	@RequestMapping("findSurveyPlanListByTaskIdForSiteSurvey")
	public JSONObject findSurveyPlanListByTaskIdForSiteSurvey(long taskId){
		JSONObject json = new JSONObject();
		JSONArray planArr = new  JSONArray();
		List<SurveyPlan> plans = surveyPlanService.findSurveyPlanByTaskId(taskId);
		for (SurveyPlan plan : plans) {
			if(plan.getTaskStatus().equals(PlanStatusEnum.NON) || plan.getTaskStatus().equals(PlanStatusEnum.CONTINUE)){
				JSONObject obj = new JSONObject();
				obj.put("oid", plan.getOid());
				obj.put("time", plan.getTime());
				planArr.add(obj);
			}
		}
		String status = "200";
		json.put("status", status);
		json.put("plans", planArr);
		return json;
	}
}
