/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.sys;

import cn.hutool.core.collection.CollectionUtil;
import com.bcxin.risk.common.dao.MarketRegionDao;
import com.bcxin.risk.common.domain.MarketRegion;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SysMarketRegionUtil {
    private static final Logger log = LoggerFactory.getLogger(SysMarketRegionUtil.class);
    @Resource
    private MarketRegionDao marketRegionDao;
    private static List<MarketRegion> CACHE_KEY_MARKET_REGION_PROVINCE = Lists.newArrayList();
    private static List<MarketRegion> CACHE_KEY_MARKET_REGION_CITY = Lists.newArrayList();
    private static List<MarketRegion> CACHE_KEY_MARKET_REGION_AREA = Lists.newArrayList();
    private static List<Long> CACHE_KEY_MARKET_REGION_ID_PROVINCE = Lists.newArrayList();
    private static List<Long> CACHE_KEY_MARKET_REGION_ID_CITY = Lists.newArrayList();
    private static List<Long> CACHE_KEY_MARKET_REGION_ID_AREA = Lists.newArrayList();

    public List<MarketRegion> findRegionByLevel(String level) {
        if ("1".equals(level)) {
            if (CollectionUtil.isNotEmpty(CACHE_KEY_MARKET_REGION_PROVINCE)) {
                return CACHE_KEY_MARKET_REGION_PROVINCE;
            }
        } else if ("2".equals(level)) {
            if (CollectionUtil.isNotEmpty(CACHE_KEY_MARKET_REGION_CITY)) {
                return CACHE_KEY_MARKET_REGION_CITY;
            }
        } else if ("3".equals(level) && CollectionUtil.isNotEmpty(CACHE_KEY_MARKET_REGION_AREA)) {
            return CACHE_KEY_MARKET_REGION_AREA;
        }
        List rList = this.marketRegionDao.findRegionByLevel(level);
        if ("1".equals(level)) {
            CACHE_KEY_MARKET_REGION_PROVINCE = rList;
        } else if ("2".equals(level)) {
            CACHE_KEY_MARKET_REGION_CITY = rList;
        } else if ("3".equals(level)) {
            CACHE_KEY_MARKET_REGION_AREA = rList;
        }
        return rList;
    }

    public List<Long> findRegionIdByLevel(String level) {
        if ("1".equals(level)) {
            if (CollectionUtil.isNotEmpty(CACHE_KEY_MARKET_REGION_ID_PROVINCE)) {
                return CACHE_KEY_MARKET_REGION_ID_PROVINCE;
            }
        } else if ("2".equals(level)) {
            if (CollectionUtil.isNotEmpty(CACHE_KEY_MARKET_REGION_ID_CITY)) {
                return CACHE_KEY_MARKET_REGION_ID_CITY;
            }
        } else if ("3".equals(level) && CollectionUtil.isNotEmpty(CACHE_KEY_MARKET_REGION_ID_AREA)) {
            return CACHE_KEY_MARKET_REGION_ID_AREA;
        }
        List rList = this.marketRegionDao.findRegionByLevel(level);
        ArrayList ridList = Lists.newArrayList();
        for (MarketRegion marketRegion : rList) {
            ridList.add(marketRegion.getOid());
        }
        if ("1".equals(level)) {
            CACHE_KEY_MARKET_REGION_ID_PROVINCE = ridList;
        } else if ("2".equals(level)) {
            CACHE_KEY_MARKET_REGION_ID_CITY = ridList;
        } else if ("3".equals(level)) {
            CACHE_KEY_MARKET_REGION_ID_AREA = ridList;
        }
        return ridList;
    }
}

