import FlowDiagram from "./element/FlowDiagram";
import Resources from "./utility/Resources";
import XMLOperate from "./utility/XMLOperate";
import StringUtil from "./utility/StringUtil";

class Canvas {
  constructor(canvas) {
    this.canvas = canvas;
    this.diagram = null;
    this.scalePreNum = 1;
  }

  Init() {
    if (this.canvas.getContext) {
      new Resources().onload(() => {
        this.diagram = new FlowDiagram(this.canvas);
        this.diagram.jbInit();
        this.diagram.paint();
      });
    }
  }

  getCurrToEdit() {
    return this.diagram.getCurrToEdit();
  }

  addStartNode() {
    this.diagram.changeStatues(FlowDiagram.ACTION_ADD_STARTNODE);
  }

  editStartNode(cn, id, name, statelabel, x, y) {
    this.diagram.editStartNode(cn, id, name, statelabel, x, y);
  }

  addCompleteNode() {
    this.diagram.changeStatues(FlowDiagram.ACTION_ADD_COMPLETENODE);
  }

  editCompleteNode(cn, id, name, statelabel, orderNum, x, y, isgather, splitStartNode, isAutoArchive) {
    this.diagram.editCompleteNode(cn, id, name, statelabel, orderNum, x, y, isgather, splitStartNode, isAutoArchive);
  }

  addGatewayNode() {
    this.diagram.changeStatues(FlowDiagram.ACTION_ADD_GATEWAYNODE);
  }

  editGatewayNode(cn, id, name, statelabel, x, y, issplit, isgather, splitStartNode) {
    this.diagram.editGatewayNode(cn, id, name, statelabel, x, y, issplit, isgather, splitStartNode);
  }

  addManualNode() {
    this.diagram.changeStatues(FlowDiagram.ACTION_ADD_MANUALNODE);
  }

  editManualNode(node, opts) {
    this.diagram.editManualNode(node, opts);
  }

  addAutoNode() {
    this.diagram.changeStatues(FlowDiagram.ACTION_ADD_AUTONODE);
  }

  editAutoNode(an, id, name, statelabel, orderNum, issplit, isgather, autoAuditType, delayDay, delayHour, delayMinute, auditDateTime, x, y, splitStartNode, autoAuditTimeEditMode, auditDateTimeScript) {
    this.diagram.editAutoNode(an, id, name, statelabel, orderNum, issplit, isgather, autoAuditType, delayDay, delayHour, delayMinute, auditDateTime, x, y, splitStartNode, autoAuditTimeEditMode, auditDateTimeScript);
  }

  addSubFlow() {
    this.diagram.changeStatues(FlowDiagram.ACTION_ADD_SUBFLOW);
  }

  editSubFlow(an, opts) {
    this.diagram.editSubFlow(an, opts);
  }

  addRelation() {
    this.diagram.changeStatues(FlowDiagram.ACTION_ADD_RELATION);
  }

  editRelation(rlt, id, name, condition, note, action, validateScript, filtercondition, editMode, processDescription, formlist) {
    this.diagram.editRelation(rlt, id, name, condition, note, action, validateScript, filtercondition, editMode, processDescription, formlist);
  }

  bigCanvas() {
    let scalePreNum1 = 1 / this.scalePreNum;
    this.canvas.getContext("2d").scale(scalePreNum1, scalePreNum1);
    let scaleNum = this.diagram.getScaleNum("big");
    console.log(scaleNum + "big");

    this.canvas.getContext("2d").scale(scaleNum, scaleNum);
    this.diagram.repaint();
    this.scalePreNum = scaleNum;
  }

  smallCanvas() {
    let scalePreNum1 = 1 / this.scalePreNum;
    this.canvas.getContext("2d").scale(scalePreNum1, scalePreNum1);
    let scaleNum = this.diagram.getScaleNum("small");
    console.log(scaleNum + "small");

    this.canvas.getContext("2d").scale(scaleNum, scaleNum);
    this.diagram.repaint();
    this.scalePreNum = scaleNum;
  }

  removeElement() {
    this.diagram.changeStatues(FlowDiagram.ACTION_REMOVE);
  }

  // yx
  alignVerticalCenter(){
    this.diagram.alignVerticalCenter();
  }
  // yx 
  alignLeft(){
    this.diagram.alignLeft();
  }
  // yx 
  alignRight(){
    this.diagram.alignRight();
  }
  // yx
  alignHorizontalCenter(){
    this.diagram.alignHorizontalCenter();
  }
  // yx
  alignTop(){
    this.diagram.alignTop();
  }
  // yx
  alignBottom(){
    this.diagram.alignBottom();
  }

  // yx
  getAllSplitNode (currentNode) {
    return this.diagram.getAllSplitNode(currentNode);
  }

  getAllBeforeNode(node, ispassed) {
    return this.diagram.getAllBeforeNode(node, ispassed);
  }

  getElementByID(id) {
    return this.diagram.getElementByID(id);
  }

  informationCheck() {
    return this.diagram.informationCheck();
  }

  toXML() {
    return this.diagram.toXML();
  }

  //xh
  check() {
    return this.diagram.check();
  }

  XMLOperate(xml) {
    const parse = new DOMParser();
    const xmldoc = parse.parseFromString(new StringUtil().replaceXML(xml), "text/xml");

    new XMLOperate(xmldoc, this.diagram).parserXML();
    this.diagram.paint();
  }
}

const OBPM = window.OBPM || {};

OBPM.FlowDiagram = Canvas;

window.OBPM = OBPM;
